/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractHeaderCheck;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="23.1.4")
@CheckID(value="R.1196")
@CheckName(value="R.1196")
@CheckLabel(labels={RuleLabel.COMMENT, RuleLabel.STYLING})
@CheckTitle(value="Element description must be in element comment or in file header comment")
@CheckDescription(value="All declarations of elements must have a description comment immediately after the file header comment or before the class.\n\nExamples for elementKind=class:\n// file header\n// class description  // ALLOWED\n\nclass myclass;\nendclass\n\n// file header\n\n// class description  // ALLOWED\nclass myclass;\nendclass\n\n// file header\nclass myclass;\n// class description  // NOT ALLOWED\nendclass\n\n// file header\nclass myclass; // NOT ALLOWED\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1196
extends AbstractHeaderCheck {
    @CheckParameter(defaultValue="", description="Element kind that requires a description. One of the following: class, module, interface, package.", name="elementKind", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    protected String pElementKind;
    private static final String CLASS = "class";
    private static final String MODULE = "module";
    private static final String INTERFACE = "interface";
    private static final String PACKAGE = "package";
    private static final Set<String> ELEMENT_KINDS = new HashSet<String>();

    static {
        ELEMENT_KINDS.add(CLASS);
        ELEMENT_KINDS.add(MODULE);
        ELEMENT_KINDS.add(INTERFACE);
        ELEMENT_KINDS.add(PACKAGE);
    }

    public Check_R_1196(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pElementKind != null && !this.pElementKind.isEmpty() && !ELEMENT_KINDS.contains(this.pElementKind)) {
            this.signalParamError("Invalid element kind: " + this.pElementKind + "!", true);
        }
    }

    @Override
    protected void analyzeHeaders(Map<String, String[]> headerLines, Map<String, Pattern[]> headerPatterns) throws IOException {
        NullProtectedList<?> elements = this.getElements();
        HashMap<ParserPath, ArrayList<RfNamedElement>> elementsPerFile = new HashMap<ParserPath, ArrayList<RfNamedElement>>();
        if (elements == null || elements.isEmpty()) {
            return;
        }
        for (Object e : elements) {
            ParserPath parserPath;
            RfNamedElement element;
            RfDefElement declaration;
            if (!(e instanceof RfNamedElement) || (declaration = (element = (RfNamedElement)e).getDeclaration()) == null || (parserPath = declaration.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            ArrayList<RfNamedElement> fileElements = (ArrayList<RfNamedElement>)elementsPerFile.get(parserPath);
            if (fileElements == null) {
                fileElements = new ArrayList<RfNamedElement>();
                elementsPerFile.put(parserPath, fileElements);
            }
            fileElements.add(element);
        }
        for (Map.Entry entry : elementsPerFile.entrySet()) {
            this.notifyCheckAlive();
            ParserPath path = (ParserPath)entry.getKey();
            List fileElements = (List)entry.getValue();
            if (fileElements.size() > 1) {
                fileElements.sort(Comparator.comparing(RfNamedElement::getStartOffset));
            }
            RfNamedElement firstElement = (RfNamedElement)fileElements.get(0);
            File file = new File(path.path);
            if (!file.canRead()) {
                this.addHit(path, 1, "Failed reading file '" + path + "'!", null);
                continue;
            }
            boolean validHeader = true;
            boolean validDescription = false;
            int lineNo = 0;
            for (String headerFilePath : this.pHeaderFilePathValue) {
                Throwable throwable = null;
                Object var17_21 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                    String line = null;
                    lineNo = 0;
                    int i = 0;
                    while (i < headerLines.get(headerFilePath).length) {
                        line = bufferedReader.readLine();
                        ++lineNo;
                        if (line == null) {
                            validHeader = false;
                            break;
                        }
                        if (this.pPatternMatchValue && headerPatterns.get(headerFilePath) != null && !headerPatterns.get(headerFilePath)[i].matcher(line).matches() || !this.pPatternMatchValue && !DVTStringUtil.replaceAll((Pattern)WHITESPACE_PATTERN, (CharSequence)line.toLowerCase(), (String)" ").trim().equals(headerLines.get(headerFilePath)[i])) {
                            if (this.pSkipMismatchedLinesValue) {
                                --i;
                            } else {
                                validHeader = false;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (!validHeader) continue;
                    line = bufferedReader.readLine();
                    ++lineNo;
                    if (line == null || !line.startsWith("//") && !line.startsWith("/*")) break;
                    validDescription = true;
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (!validHeader) {
                this.addHit(path, 1, "Invalid header for '" + path + "'!", null);
                continue;
            }
            if (!validDescription) {
                if (lineNo == firstElement.getLine()) {
                    this.addHit(firstElement, "Missing description for " + firstElement.getKindName() + " '" + firstElement.getName() + "'!", null);
                    continue;
                }
                this.analyzeElementComment(firstElement);
            }
            if (fileElements.size() == 1) continue;
            int elementIndex = 1;
            while (elementIndex < fileElements.size()) {
                this.analyzeElementComment((RfNamedElement)fileElements.get(elementIndex));
                ++elementIndex;
            }
        }
    }

    public void analyzeElementComment(RfNamedElement element) {
        CommentBlock commentBlock = element.getCommentBlock();
        if (commentBlock == null) {
            this.addHit(element, "Missing description for " + element.getKindName() + " '" + element.getName() + "'!", null);
            return;
        }
        String aboveComment = commentBlock.getAboveComment();
        if (aboveComment == null || aboveComment.isEmpty()) {
            this.addHit(element, "Missing description for " + element.getKindName() + " '" + element.getName() + "'!", null);
        }
    }

    private NullProtectedList<?> getElements() {
        switch (this.pElementKind) {
            case "class": {
                return this.fOVMProject.getAllClasses();
            }
            case "module": {
                return this.fOVMProject.getAllModules();
            }
            case "interface": {
                return this.fOVMProject.getAllInterfaces();
            }
            case "package": {
                return new NullProtectedList<RfPackage>(this.fOVMProject.getAllPackages());
            }
        }
        return null;
    }
}

