/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_R_1197;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMultilineMethodDeclarationCheck;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;

@CheckVersion(value="23.1.4")
@CheckID(value="R.1197")
@CheckName(value="R.1197")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.INDENTATION, RuleLabel.STYLING})
@CheckTitle(value="Method argument indentation")
@CheckDescription(value="For long method declarations, the arguments wrapped on new lines should be indented <nofSpaces> spaces from the method declaration.\n\nExample when 'nofSpaces' is 2:\n\nfunction void foo(int arg1,\n  int arg2,           // ALLOWED\n    int arg3);        // NOT ALLOWED\n    // METHOD BODY\nendfunction\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_R_1197.class)
public class Check_R_1197
extends AbstractMultilineMethodDeclarationCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="2", description="The number of spaces used for indentation.", name="nofSpaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private Integer pNofSpaces;

    public Check_R_1197(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void analyzeArguments(ParserPath path, Map<Integer, ArrayList<RfFieldDef>> argumentsPerLine, RfDefElement declarationDefElement) {
        int declarationLine = declarationDefElement.getStartLine();
        LiteralToken declarationToken = this.getWSParser().getFirstTokenOnLine(path, declarationLine);
        if (declarationToken == null) {
            return;
        }
        for (Map.Entry<Integer, ArrayList<RfFieldDef>> entry : argumentsPerLine.entrySet()) {
            int line = entry.getKey();
            if (line == declarationLine) continue;
            ArrayList<RfFieldDef> argumentsOnLine = entry.getValue();
            RfFieldDef firstArgument = argumentsOnLine.get(0);
            for (RfFieldDef argument : argumentsOnLine) {
                if (firstArgument.getStartOffset() > argument.getStartOffset()) {
                    firstArgument = argument;
                    continue;
                }
                if (firstArgument.getStartOffset() != argument.getStartOffset() || firstArgument.getStartVirtualOffset() <= argument.getStartVirtualOffset()) continue;
                firstArgument = argument;
            }
            LiteralToken firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(path, line);
            if (firstTokenOnLine == null) continue;
            int requiredNofSpaces = declarationToken.getNoSpacesBefore() + this.pNofSpaces;
            if (firstTokenOnLine.getNoTabsBefore() != 0) {
                this.addHit(path, line, "Tabs used for indentation of argument '" + LintUtils.getNamedElementFullName(firstArgument.getNamedElement()) + "'!", null, new VerissimoAutofixAdditionalInfo(requiredNofSpaces));
                continue;
            }
            if (firstTokenOnLine.getNoSpacesBefore() == requiredNofSpaces) continue;
            this.addHit(path, line, "Number of spaces used for indentation of argument '" + LintUtils.getNamedElementFullName(firstArgument.getNamedElement()) + "' must be " + requiredNofSpaces + "!", null, new VerissimoAutofixAdditionalInfo(requiredNofSpaces));
        }
    }

    @Override
    protected boolean checkDeclaration(ParserPath path, int declarationLine, ArrayList<RfFieldDef> arguments) {
        int lastLine = arguments.get(arguments.size() - 1).getStartLine();
        return declarationLine < lastLine;
    }
}

