/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractBoundsCheck;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.6")
@CheckID(value="R.1198")
@CheckName(value="R.1198")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.SELECT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Out of bounds range of index variable in array select")
@CheckDescription(value="This check flags array selects that could be out of bounds due to the size of the index variable.\nIf the array select address is out of bounds the returned value will be X for 4-state variables and 0 for 2-state variables. This can lead to unexpected behaviour that is hard to debug.\n\nImplementation Notes:\nFor parameterized size dimensions, modules must be elaborated in order to find the value of the parameter.\nIf a module is not elaborated the check will not fail for any accesses of parameterized size dimensions inside the module, but will still fail for accesses of non-parameterized dimensions.\n\nExamples:\nlogic var[7:0];\nlogic [4:0] select_var1\nlogic [1:0] select_var2\n\nvar[select_var1] //not allowed\nvar[select_var2] //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1198
extends AbstractBoundsCheck {
    public Check_R_1198(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkBounds(RfHid hid, IRfNamedElement scope, List<IHidObject> selects, IRfNamedElement arrayElement, ELManager elManager, ELParamValuesHidEvaluator emptyEvaluator, Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement, String[] generateBlockPaths, ParserPath parserPath) {
        Map<ELSpecializationWrapper, ELSpecializationWrapper> specializationWrappers;
        if (!(arrayElement instanceof RfField)) {
            return;
        }
        IRfNamedElement arrayFieldAssocType = ((RfField)arrayElement).getAssociatedType();
        while (arrayFieldAssocType instanceof RfTypeAlias) {
            arrayFieldAssocType = ((RfTypeAlias)arrayFieldAssocType).getAssociatedType();
        }
        if (arrayFieldAssocType == null) {
            return;
        }
        if (RfListType.isNotFixedArray((IRfScopeElement)arrayFieldAssocType)) {
            return;
        }
        if (!(arrayFieldAssocType.getDeclaration() instanceof RfDefElement)) {
            return;
        }
        DataType dataType = ((RfDefElement)arrayFieldAssocType.getDeclaration()).getDataType(arrayFieldAssocType);
        if (dataType == null) {
            return;
        }
        List<IndexType> unpackedDimensionsList = dataType.getUnpackedDimension();
        if (unpackedDimensionsList == null || unpackedDimensionsList.isEmpty()) {
            return;
        }
        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)arrayElement, null, (boolean)false, (ELManager)elManager);
        guardian.updateElements(arrayElement, scope);
        IRfScopeElement enclosingScope = arrayElement.getEnclosingScope(RfModule.class);
        Map<ELSpecializationWrapper, ELSpecializationWrapper> map = specializationWrappers = enclosingScope != null ? specsPerElement.get(enclosingScope) : null;
        if (specializationWrappers != null && !specializationWrappers.isEmpty()) {
            for (ELSpecializationWrapper wrapper : specializationWrappers.values()) {
                IHidEvaluator specializationEvaluator = wrapper.getHidEvaluator(elManager);
                if (!(specializationEvaluator instanceof ELParamValuesHidEvaluator)) continue;
                String pathsText = wrapper.getPathsText();
                if (generateBlockPaths != null) {
                    boolean foundCorrespondingGenerateBlockPath = false;
                    String[] stringArray = generateBlockPaths;
                    int n = generateBlockPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String generateBlockPath = stringArray[n2];
                        if (generateBlockPath.startsWith(pathsText)) {
                            foundCorrespondingGenerateBlockPath = true;
                        }
                        ++n2;
                    }
                    if (!foundCorrespondingGenerateBlockPath) continue;
                }
                this.findAndCheckDimensions(hid, scope, selects, arrayElement, elManager, guardian, parserPath, unpackedDimensionsList, (ELParamValuesHidEvaluator)specializationEvaluator, pathsText);
            }
        } else {
            this.findAndCheckDimensions(hid, scope, selects, arrayElement, elManager, guardian, parserPath, unpackedDimensionsList, emptyEvaluator, null);
        }
    }

    private void findAndCheckDimensions(RfHid hid, IRfNamedElement scope, List<IHidObject> selects, IRfNamedElement arrayElement, ELManager elManager, IHidEvaluationGuardian guardian, ParserPath parserPath, List<IndexType> unpackedDimensionsList, ELParamValuesHidEvaluator evaluator, String pathsText) {
        int i = 0;
        while (i < unpackedDimensionsList.size() && i < selects.size()) {
            block5: {
                Integer bigDimension;
                Integer smallDimension;
                IHidObject currentSelect;
                block7: {
                    BitVectorContext dummyContextOrigin;
                    IndexType indexType;
                    block6: {
                        IELParamValue rhValue;
                        IELParamValue lhValue;
                        ListContainer rhValues;
                        currentSelect = selects.get(i);
                        if (currentSelect == null || this.pSkipVariablesInSelects && !this.shouldBeEvaluatedForActualValue(currentSelect) || currentSelect instanceof RfHidOperator && ((HidOperator)currentSelect).isRangeOrPartSelect()) break block5;
                        indexType = unpackedDimensionsList.get(i);
                        smallDimension = null;
                        bigDimension = null;
                        dummyContextOrigin = BitVectorContext.of((IRfNamedElement)scope, (boolean)false);
                        if (!(indexType.getRangeObject() instanceof RfHidOperator)) break block6;
                        RfHidOperator operator = (RfHidOperator)indexType.getRangeObject();
                        if (!operator.isRangeOrPartSelect() || (rhValues = operator.getRHValues()) == null || rhValues.size() != 1 || ELUtils.isUnsuccessfulEval((IELParamValue)(lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)operator.getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian)))) || !(lhValue instanceof ELParamValues.ParamValueNumber) || ELUtils.isUnsuccessfulEval((IELParamValue)(rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhValues.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian)))) || !(rhValue instanceof ELParamValues.ParamValueNumber)) break block5;
                        smallDimension = lhValue.intValue();
                        bigDimension = rhValue.intValue();
                        break block7;
                    }
                    if (indexType.getRangeObject() == null) break block7;
                    smallDimension = 0;
                    IELParamValue paramValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)indexType.getRangeObject(), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                    if (ELUtils.isUnsuccessfulEval((IELParamValue)paramValue) || !(paramValue instanceof ELParamValues.ParamValueNumber)) break block5;
                    bigDimension = paramValue.intValue() - 1;
                }
                if (smallDimension != null && bigDimension != null) {
                    this.checkDimensions(hid, arrayElement, elManager, evaluator, i, currentSelect, smallDimension, bigDimension, parserPath, pathsText, scope);
                }
            }
            ++i;
        }
    }
}

