/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.7")
@CheckID(value="R.1199")
@CheckName(value="R.1199")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONDITIONAL, RuleLabel.PARENTHESIS, RuleLabel.CODE_COMPLEXITY})
@CheckTitle(value="Ternary expressions nested in other ternary conditions should be enclosed by parentheses")
@CheckDescription(value="This rule flags the usage of nested ternary expressions that are not enclosed by parentheses.\n\nExample:\n\nb = (a>2)? (a<10)? 10:0:0; //not allowed\nb = (a>2)? ((a<10)? 10:0):0; //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1199
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="true, false", description="Comma separated list of which branches of the ternary condition will be checked. Can be one or multiple of: true, false.", name="checkBranch", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckBranch;
    private static final char RIGHT_PAREN_CHAR = ')';
    private static final char LEFT_PAREN_CHAR = '(';

    public Check_R_1199(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        List<String> acceptedValues = Arrays.asList("true", "false");
        for (String branch : this.pCheckBranch) {
            if (acceptedValues.contains(branch)) continue;
            this.signalParamError("'" + branch + "' is not an allowed value!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                Check_R_1199.this.notifyCheckAlive();
                if (!hidOperator.isConditionalTernary()) {
                    return true;
                }
                if (Check_R_1199.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                ListContainer rhValue = hidOperator.getRHValues();
                if (rhValue == null || rhValue.isEmpty() || rhValue.size() != 2) {
                    return true;
                }
                if (Check_R_1199.this.pCheckBranch.contains("true")) {
                    Check_R_1199.this.checkHit((IHidObject)rhValue.get(1), this.parserPath, true);
                }
                if (Check_R_1199.this.pCheckBranch.contains("false")) {
                    Check_R_1199.this.checkHit((IHidObject)rhValue.get(0), this.parserPath, false);
                }
                return true;
            }
        });
    }

    private void checkHit(IHidObject value, ParserPath parserPath, boolean condition) {
        LiteralToken nextToken;
        if (!(value instanceof RfHidOperator)) {
            return;
        }
        RfHidOperator operator = (RfHidOperator)value;
        if (!operator.isConditionalTernary()) {
            return;
        }
        if (operator.getReparseInfo() != null) {
            return;
        }
        HidOperatorOccurrence occurrence = operator.getOccurrence();
        if (occurrence == null) {
            return;
        }
        LiteralToken tokenOnOpen = this.getWSParser().getTokenContainingOffset(occurrence.getOpenBoundary(), parserPath);
        int i = occurrence.getOpenBoundary() - tokenOnOpen.getOffsetFile();
        String tokenString = tokenOnOpen.getStringToken();
        DVTStringBuilder finalStringBuilder = new DVTStringBuilder();
        finalStringBuilder.append(tokenString);
        while (tokenString.charAt(i) != '?' && tokenString.charAt(i) != ':') {
            if (--i != -1) continue;
            LiteralToken prevToken = this.getWSParser().getPrevToken(tokenOnOpen, parserPath);
            while (prevToken != null && prevToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                tokenOnOpen = prevToken;
                prevToken = this.getWSParser().getPrevToken(tokenOnOpen, parserPath);
            }
            tokenOnOpen = prevToken;
            if (tokenOnOpen == null) break;
            tokenString = tokenOnOpen.getStringToken();
            i = tokenString.length() - 1;
            finalStringBuilder.prepend(tokenString);
        }
        finalStringBuilder = new DVTStringBuilder(finalStringBuilder.toString().substring(++i));
        tokenOnOpen = this.getWSParser().getTokenContainingOffset(occurrence.getOpenBoundary(), parserPath);
        LiteralToken tokenOnClose = this.getWSParser().getTokenContainingOffset(occurrence.getCloseBoundary() - 1, parserPath);
        if (tokenOnClose == null || tokenOnOpen == null) {
            return;
        }
        if (!tokenOnOpen.equals(tokenOnClose)) {
            nextToken = this.getWSParser().getNextToken(tokenOnOpen, parserPath);
            while (nextToken != null && !nextToken.equals(tokenOnClose)) {
                tokenOnOpen = nextToken;
                nextToken = this.getWSParser().getNextToken(tokenOnOpen, parserPath);
                if (tokenOnOpen.getZone() != SVTBWhitespaceParser.ZoneType.CODE) continue;
                finalStringBuilder.append(tokenOnOpen.getStringToken());
            }
        }
        i = occurrence.getCloseBoundary() - 1 - tokenOnClose.getOffsetFile();
        tokenString = tokenOnClose.getStringToken();
        if (!tokenOnOpen.equals(tokenOnClose)) {
            finalStringBuilder.append(tokenOnClose.getStringToken());
        }
        if (condition) {
            while (tokenString.charAt(i) != ':') {
                if (++i != tokenString.length()) continue;
                nextToken = this.getWSParser().getNextToken(tokenOnClose, parserPath);
                while (nextToken != null && nextToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                    tokenOnClose = nextToken;
                    nextToken = this.getWSParser().getNextToken(tokenOnClose, parserPath);
                }
                tokenOnClose = nextToken;
                if (tokenOnClose == null) break;
                tokenString = tokenOnClose.getStringToken();
                i = 0;
                finalStringBuilder.append(tokenString);
            }
            finalStringBuilder = new DVTStringBuilder(finalStringBuilder.toString().substring(0, finalStringBuilder.length() - (tokenString.length() - i)));
        } else {
            int endIndex = finalStringBuilder.length() - (tokenOnClose.getLength() - i);
            String substring = finalStringBuilder.toString().substring(0, endIndex);
            int openParan = StringUtils.countMatches((String)substring, (String)"(") - StringUtils.countMatches((String)substring, (String)")");
            while (tokenString.charAt(i) != ';') {
                if (tokenString.charAt(i) == '(') {
                    ++openParan;
                } else if (tokenString.charAt(i) == ')' && --openParan == -1) break;
                if (++i != tokenString.length()) continue;
                LiteralToken nextToken2 = this.getWSParser().getNextToken(tokenOnClose, parserPath);
                while (nextToken2 != null && nextToken2.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                    tokenOnClose = nextToken2;
                    nextToken2 = this.getWSParser().getNextToken(tokenOnClose, parserPath);
                }
                tokenOnClose = nextToken2;
                if (tokenOnClose == null) break;
                tokenString = tokenOnClose.getStringToken();
                i = 0;
                finalStringBuilder.append(tokenString);
            }
            finalStringBuilder = new DVTStringBuilder(finalStringBuilder.toString().substring(0, finalStringBuilder.length() - (tokenString.length() - i)));
        }
        if (!this.isWrappedInParentheses(finalStringBuilder.toString().trim())) {
            this.addHit(parserPath, (HidOccurrence)occurrence, "Nested ternary expression " + value + " is not enclosed by parentheses!");
        }
    }

    private boolean isWrappedInParentheses(String returnExpression) {
        if (returnExpression.length() == 1) {
            return false;
        }
        int openClosedParens = 0;
        int index = 0;
        while (index < returnExpression.length()) {
            char ch = returnExpression.charAt(index);
            if (ch == '(') {
                ++openClosedParens;
            } else if (ch == ')') {
                --openClosedParens;
            }
            if (openClosedParens == 0 && index != returnExpression.length() - 1) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

