/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;

@CheckVersion(value="23.1.7")
@CheckID(value="R.1200")
@CheckName(value="R.1200")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CONDITIONAL_DIRECTIVE})
@CheckTitle(value="Conditional compilation compiler directives alignment")
@CheckDescription(value="Keep branching preprocessor directives (`ifdef, `ifndef, `else, `elsif, `endif) aligned to the left even if they are nested.\nUn-indented branching preprocessor directives disrupt the flow of reading to emphasize that there is conditional text.\nLeaving conditional branch text un-indented will result in post-processed text looking properly indented.\n\nExamples:\n`ifdef FOO   //allowed\n  parameter bit A = 1;\n`endif       //allowed\n\nExamples:\n  `ifdef FOO  //not allowed\n  parameter bit A = 1;\n `endif       //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1200
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static String IFDEF = "`ifdef";
    private static String IFNDEF = "`ifndef";
    private static String ELSE = "`else";
    private static String ELSIF = "`elsif";
    private static String ENDIF = "`endif";
    private static Set<String> directiveNames = new HashSet<String>();

    static {
        directiveNames.add(IFDEF);
        directiveNames.add(IFNDEF);
        directiveNames.add(ELSE);
        directiveNames.add(ELSIF);
        directiveNames.add(ENDIF);
    }

    public Check_R_1200(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> allFilesInProject = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath path : allFilesInProject) {
            TreeSet<Integer> lines;
            CodePreprocFileInfo preprocInfo;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this) || (preprocInfo = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos().get(path)) == null || (lines = preprocInfo.getLines()) == null) continue;
            for (Integer line : lines) {
                CodePreprocLineInfo info = preprocInfo.getInfo(line);
                int lineNo = info.getLine();
                this.checkLineForDirective(lineNo, path);
            }
            CodePreprocLineInfo[] codePreprocLineInfo = preprocInfo.getCodePreprocLineInfo();
            if (codePreprocLineInfo == null || codePreprocLineInfo.length == 0) continue;
            int i = 0;
            while (i < codePreprocLineInfo.length - 1) {
                int j = codePreprocLineInfo[i].getLine() + 1;
                while (j < codePreprocLineInfo[i + 1].getLine()) {
                    this.checkLineForDirective(j, path);
                    ++j;
                }
                i += 2;
            }
        }
    }

    private void checkLineForDirective(int lineNo, ParserPath path) {
        for (LiteralToken token : this.getWSParser().getTokensOnLine(path, lineNo)) {
            String tokenString = token.getStringToken();
            if (!tokenString.contains("`")) continue;
            for (String directive : directiveNames) {
                if (!tokenString.contains(directive) || token.isFirstTokenOnLine() && token.getNoSpacesBefore() == 0 && token.getNoTabsBefore() == 0) continue;
                this.addHit(path, lineNo, "Branching preprocessor directive " + directive + " must be left-aligned and un-indented!", null);
            }
        }
    }
}

