/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.8")
@CheckID(value="R.1201")
@CheckName(value="R.1201")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.RANDOMIZATION, RuleLabel.VERIFICATION})
@CheckTitle(value="A sequence randomize call must be placed before the sequence start method")
@CheckDescription(value="xvm_sequence.randomize() must be called before xvm_sequence.start().\nImplementation notes:\nThis check does not take into account all the possible ways that the code can be executed in order to determine if a randomize call is before a start call.\n\nCheck supports pre-waiving.")
public class Check_R_1201
extends OVMComplianceCheck {
    private static final String RANDOMIZE = "randomize";
    private static final String START = "start";
    private static final String UVM_SEQUENCE = "uvm_sequence";
    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> randomizeCallsMap;
    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> startCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
    private int maxOffset;

    public Check_R_1201(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.randomizeCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
    }

    @Override
    public void performCheckImpl() {
        this.startCallsMap.clear();
        this.randomizeCallsMap.clear();
        this.getAllStartAndRandomizeHids();
        if (this.startCallsMap.isEmpty()) {
            return;
        }
        Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> validStartHids = this.getAllValidStartHids();
        Set<RfHidAccess> startedSequences = this.startCallsMap.keySet();
        for (RfHidAccess sequence : startedSequences) {
            if (sequence.getParentHid() == null) continue;
            String sequenceName = sequence.getParentHid().getName();
            if ("this".equals(sequenceName)) {
                sequenceName = sequence.getAssociatedType() != null ? sequence.getAssociatedType().getName() : "";
            }
            String sequenceType = sequence.getAssociatedType() instanceof RfNamedElement ? LintUtils.getNamedElementFullName((RfNamedElement)sequence.getAssociatedType()) : "";
            Map<RfNamedElement, Set<HidOccurrence>> startCalls = this.startCallsMap.get((Object)sequence);
            if (startCalls == null || startCalls.isEmpty()) continue;
            this.notifyCheckAlive();
            Set<RfNamedElement> startCallsScopes = startCalls.keySet();
            if (startCallsScopes == null || startCallsScopes.isEmpty()) continue;
            for (RfNamedElement scope : startCallsScopes) {
                Set<HidOccurrence> validOccurrences = validStartHids.get((Object)sequence) != null ? validStartHids.get((Object)sequence).get(scope) : null;
                Collection occurrencesInScope = startCalls.get(scope);
                if (occurrencesInScope == null) continue;
                for (HidOccurrence occurrence : occurrencesInScope) {
                    if (validOccurrences != null && validOccurrences.contains(occurrence)) continue;
                    this.addHit(scope.getDeclaration().getParserPath(), occurrence, "Sequence '" + sequenceName + "' of type '" + sequenceType + "' is not randomized before start!");
                }
            }
        }
    }

    private void getAllStartAndRandomizeHids() {
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (Check_R_1201.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                HidAccess parentAccess = hidObject.getParentAccess();
                if (!(parentAccess instanceof RfHidAccess) || parentAccess.getAssociatedType() == null) {
                    return true;
                }
                IRfNamedElement parentType = parentAccess.getAssociatedType();
                if (!(parentType instanceof RfClass)) {
                    return true;
                }
                boolean isSequence = ((RfClass)parentType).isSubClass(Check_R_1201.UVM_SEQUENCE, true);
                if (!isSequence) {
                    return true;
                }
                Check_R_1201.this.notifyCheckAlive();
                if (!(this.holder instanceof RfHidHolder)) {
                    return true;
                }
                IRfNamedElement scope = ((RfHidHolder)this.holder).getScope();
                if (!(scope instanceof RfNamedElement)) {
                    return true;
                }
                if (!(parentAccess instanceof RfHidAccess)) {
                    return true;
                }
                RfHidAccess hidAccess = (RfHidAccess)parentAccess;
                if (Check_R_1201.START.equals(hidObject.getName())) {
                    Map<RfNamedElement, Set<HidOccurrence>> map;
                    Set<HidOccurrence> startCallOccurrencesInScope;
                    if (!Check_R_1201.this.startCallsMap.containsKey((Object)hidAccess)) {
                        Check_R_1201.this.startCallsMap.put(hidAccess, new HashMap());
                    }
                    if ((startCallOccurrencesInScope = (map = Check_R_1201.this.startCallsMap.get((Object)hidAccess)).get(scope)) == null) {
                        startCallOccurrencesInScope = new LinkedHashSet<HidOccurrence>();
                        map.put((RfNamedElement)scope, startCallOccurrencesInScope);
                    }
                    startCallOccurrencesInScope.add(hidObject.getOccurrence());
                } else if (Check_R_1201.RANDOMIZE.equals(hidObject.getName())) {
                    Map<RfNamedElement, Set<HidOccurrence>> map;
                    Set<HidOccurrence> randomizeCallOccurrencesInScope;
                    if (!Check_R_1201.this.randomizeCallsMap.containsKey((Object)hidAccess)) {
                        Check_R_1201.this.randomizeCallsMap.put(hidAccess, new HashMap());
                    }
                    if ((randomizeCallOccurrencesInScope = (map = Check_R_1201.this.randomizeCallsMap.get((Object)hidAccess)).get(scope)) == null) {
                        randomizeCallOccurrencesInScope = new LinkedHashSet<HidOccurrence>();
                        map.put((RfNamedElement)scope, randomizeCallOccurrencesInScope);
                    }
                    randomizeCallOccurrencesInScope.add(hidObject.getOccurrence());
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), visitor);
    }

    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> getAllValidStartHids() {
        HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> validStartHids = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
        Set<RfHidAccess> sequencesStarted = this.startCallsMap.keySet();
        for (RfHidAccess sequence : sequencesStarted) {
            Map<RfNamedElement, Set<HidOccurrence>> randomizeCalls = this.randomizeCallsMap.get((Object)sequence);
            Map<RfNamedElement, Set<HidOccurrence>> startCalls = this.startCallsMap.get((Object)sequence);
            if (startCalls == null || startCalls.isEmpty() || randomizeCalls == null || randomizeCalls.isEmpty()) continue;
            final Set<RfNamedElement> randomizeCallsScopes = randomizeCalls.keySet();
            Set<RfNamedElement> startCallsScopes = startCalls.keySet();
            if (startCallsScopes == null || startCallsScopes.isEmpty() || randomizeCallsScopes == null || randomizeCallsScopes.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfNamedElement scope : startCallsScopes) {
                Collection startOccurences = startCalls.get(scope);
                if (startOccurences == null || startOccurences.isEmpty()) continue;
                RfNamedElement parentScope = scope;
                while (parentScope instanceof RfActionBlock) {
                    parentScope = parentScope.getEnclosingScope();
                }
                if (parentScope == null) continue;
                this.maxOffset = 0;
                for (HidOccurrence startOccurence : startOccurences) {
                    if (startOccurence.getOffset() <= this.maxOffset) continue;
                    this.maxOffset = startOccurence.getOffset();
                }
                final ArrayList<HidOccurrence> randomizeOccurrences = new ArrayList<HidOccurrence>();
                RfHidVisitor visitor = new RfHidVisitor(){

                    public boolean visit(RfHid hidObject) {
                        if (hidObject.getOffset() > Check_R_1201.this.maxOffset) {
                            return false;
                        }
                        IRfNamedElement element = hidObject.getElement();
                        if (element == null || !(element instanceof RfFunction)) {
                            return true;
                        }
                        for (RfNamedElement randomizeScope : randomizeCallsScopes) {
                            if (!randomizeScope.hasAsEnclosingScope((IRfScopeElement)element) && !randomizeScope.equals(element)) continue;
                            randomizeOccurrences.add(hidObject.getOccurrence());
                            return false;
                        }
                        return true;
                    }
                };
                parentScope.visitHidObject(null, visitor);
                for (RfNamedElement randomizeScope : randomizeCallsScopes) {
                    if (!randomizeScope.equals(parentScope) && !randomizeScope.hasAsEnclosingScope(parentScope)) continue;
                    randomizeOccurrences.addAll((Collection<HidOccurrence>)randomizeCalls.get(randomizeScope));
                }
                int firstRandomizeOffset = this.getFirstRandomizeOffset(randomizeOccurrences);
                if (firstRandomizeOffset < 0) continue;
                for (HidOccurrence occurence : startOccurences) {
                    if (occurence.getOffset() < firstRandomizeOffset) continue;
                    if (!validStartHids.containsKey((Object)sequence)) {
                        validStartHids.put(sequence, new HashMap());
                    }
                    if (!((Map)validStartHids.get((Object)sequence)).containsKey(scope)) {
                        ((Map)validStartHids.get((Object)sequence)).put(scope, new HashSet());
                    }
                    ((Set)((Map)validStartHids.get((Object)sequence)).get(scope)).add(occurence);
                }
            }
        }
        return validStartHids;
    }

    private int getFirstRandomizeOffset(Collection<HidOccurrence> randomizeOccurrences) {
        if (randomizeOccurrences == null || randomizeOccurrences.isEmpty()) {
            return -1;
        }
        int offset = -1;
        boolean first = true;
        for (HidOccurrence hidOccurrence : randomizeOccurrences) {
            if (first) {
                offset = hidOccurrence.getOffset();
                first = false;
                continue;
            }
            if (hidOccurrence.getOffset() >= offset) continue;
            offset = hidOccurrence.getOffset();
        }
        return offset;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

