/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="23.1.8")
@CheckID(value="R.1202")
@CheckName(value="R.1202")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.PARAMETER, RuleLabel.PARENTHESIS, RuleLabel.DESIGN})
@CheckTitle(value="Module declaration format")
@CheckDescription(value="This check verifies that the opening parenthesis are on the same line as the module declaration, and the first port is declared on the following line.\nThe closing parenthesis should be on its own line, and have the same indentation as the first line in the module declaration.\nDeclaration lines following the first should be indented relative to the first line with two spaces.\nParameters and ports must each be declared on their own line.\n\nExamples:\nmodule foo \n( // not allowed\ninput var logic clk_i, // not allowed\n  input var logic rst_ni,\n\tinput var logic [7:0] d_i,\toutput var logic [7:0] q_o //not allowed\n   ); // not allowed\nendmodule\n\nmodule foo2#( parameter int unsigned Width = 8,//not allowed \n  parameter int unsigned Width2 = 8,\n    parameter int unsigned Width3 = 8, //not allowed\n  parameter int unsigned Width4 = 8\n) ( //allowed\n  input var logic clk_i,\n input var logic rst_ni, //not allowed \n  input var logic [Width-1:0] d_i,\n\toutput var logic [Width-1:0] q_o\n);\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1202
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private boolean hasParameters;
    private boolean hasPorts;

    public Check_R_1202(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement eachModule : this.fOVMProject.getAllModules()) {
            LiteralToken prevToken;
            this.hasParameters = false;
            this.hasPorts = false;
            RfDefElement moduleDeclaration = eachModule.getDeclaration();
            if (moduleDeclaration == null) continue;
            int declarationLine = moduleDeclaration.getStartLine();
            ParserPath parserPath = moduleDeclaration.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            LiteralToken token = this.getWSParser().getTokenContainingOffset(moduleDeclaration.getStartOffset(), parserPath);
            if (token == null || (prevToken = this.getWSParser().getPrevToken(token, parserPath)) == null) continue;
            int moduleIndentation = prevToken.getNoSpacesBefore();
            this.checkPortsAndParameters(eachModule, parserPath);
            this.checkIndentationAndParanthesis(eachModule, parserPath, declarationLine, moduleIndentation);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkIndentationAndParanthesis(RfNamedElement module, ParserPath parserPath, int declarationLine, int moduleIndentation) {
        if (!this.hasPorts && !this.hasParameters) {
            return;
        }
        token = this.getWSParser().getTokenContainingOffset(module.getStartOffset(), parserPath);
        paranthesisCnt = 0;
        closingParanthesisIndex = -1;
        closingParanthesisLine = -1;
        lastCheckedLine = declarationLine;
        shouldBreak = false;
        while (token != null) {
            stringToken = token.getStringToken();
            i = 0;
            while (i < stringToken.length()) {
                if (stringToken.charAt(i) == '(' && ++paranthesisCnt == 1 && token.getLineNumber() != declarationLine) {
                    if (this.hasParameters) {
                        this.addHit(parserPath, token.getLineNumber(), "The opening parenthesis for the parameters list must be on the same line as the module declaration!", null);
                    } else {
                        this.addHit(parserPath, token.getLineNumber(), "The opening parenthesis for the ports list must be on the same line as the module declaration!", null);
                    }
                }
                if (stringToken.charAt(i) == ')' && --paranthesisCnt == 0) {
                    closingParanthesisLine = token.getLineNumber();
                    closingParanthesisIndex = i;
                    shouldBreak = true;
                    break;
                }
                ++i;
            }
            if (shouldBreak) break;
            if (token.getLineNumber() != lastCheckedLine) {
                lastCheckedLine = token.getLineNumber();
                firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(parserPath, token.getLineNumber());
                if (firstTokenOnLine == null) {
                    return;
                }
                if (firstTokenOnLine.getNoTabsBefore() != 0) {
                    this.addHit(parserPath, token.getLineNumber(), "You should not use tabs for indentation!", null);
                } else if (firstTokenOnLine.getNoSpacesBefore() != moduleIndentation + 2) {
                    this.addHit(parserPath, lastCheckedLine, "Wrong indentation! You should use " + (moduleIndentation + 2) + " whitespaces!", null);
                }
            }
            if ((token = this.getWSParser().getNextToken(token, parserPath)) != null) ** GOTO lbl43
            break;
lbl-1000:
            // 1 sources

            {
                token = this.getWSParser().getNextToken(token, parserPath);
lbl43:
                // 2 sources

                ** while (token != null && token.getZone() != SVTBWhitespaceParser.ZoneType.CODE)
            }
lbl44:
            // 1 sources

        }
        if (token == null) {
            return;
        }
        firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(parserPath, token.getLineNumber());
        if (firstTokenOnLine == null) {
            return;
        }
        if (closingParanthesisIndex != 0 || firstTokenOnLine != token) {
            if (this.hasParameters) {
                this.addHit(parserPath, token.getLineNumber(), "The closing paranthesis of the parameters list should be on its own line!", null);
            } else {
                this.addHit(parserPath, token.getLineNumber(), "The closing paranthesis of the ports list should be on its own line!", null);
            }
        } else if (token.getNoTabsBefore() != 0) {
            this.addHit(parserPath, token.getLineNumber(), "You should not use tabs for indentation!", null);
        } else if (token.getNoSpacesBefore() != moduleIndentation) {
            if (this.hasParameters) {
                this.addHit(parserPath, token.getLineNumber(), "The closing paranthesis of the parameters list should have the same indentation as the module declaration!", null);
            } else {
                this.addHit(parserPath, token.getLineNumber(), "The closing paranthesis of the ports list should have the same indentation as the module declaration!", null);
            }
        }
        if (!this.hasParameters || !this.hasPorts) {
            return;
        }
        paranthesisCnt = 0;
        shouldBreak = false;
        lastCheckedLine = token.getLineNumber();
        while (token != null) {
            stringToken = token.getStringToken();
            i = closingParanthesisIndex + 1;
            while (i < stringToken.length()) {
                if (stringToken.charAt(i) == '(' && ++paranthesisCnt == 1 && token.getLineNumber() != closingParanthesisLine) {
                    this.addHit(parserPath, token.getLineNumber(), "The opening parenthesis for the ports list must be on the same line as the closing paranthesis of the parameters list!", null);
                }
                if (stringToken.charAt(i) == ')' && --paranthesisCnt == 0) {
                    closingParanthesisIndex = i;
                    shouldBreak = true;
                    break;
                }
                ++i;
            }
            if (shouldBreak) break;
            if (token.getLineNumber() != lastCheckedLine) {
                lastCheckedLine = token.getLineNumber();
                firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(parserPath, token.getLineNumber());
                if (firstTokenOnLine == null) {
                    return;
                }
                if (firstTokenOnLine.getNoTabsBefore() != 0) {
                    this.addHit(parserPath, token.getLineNumber(), "You should not use tabs for indentation!", null);
                } else if (firstTokenOnLine.getNoSpacesBefore() != moduleIndentation + 2) {
                    this.addHit(parserPath, lastCheckedLine, "Wrong indentation! You should use " + (moduleIndentation + 2) + " whitespaces!", null);
                }
            }
            if ((token = this.getWSParser().getNextToken(token, parserPath)) != null) ** GOTO lbl103
            break;
lbl-1000:
            // 1 sources

            {
                token = this.getWSParser().getNextToken(token, parserPath);
lbl103:
                // 2 sources

                ** while (token != null && token.getZone() != SVTBWhitespaceParser.ZoneType.CODE)
            }
lbl104:
            // 1 sources

            if (closingParanthesisIndex == -1) continue;
            closingParanthesisIndex = -1;
        }
        if (token == null) {
            return;
        }
        firstTokenOnLine = this.getWSParser().getFirstTokenOnLine(parserPath, token.getLineNumber());
        if (firstTokenOnLine == null) {
            return;
        }
        if (closingParanthesisIndex != 0 || firstTokenOnLine != token) {
            this.addHit(parserPath, token.getLineNumber(), "The closing paranthesis of the ports list should be on its own line!", null);
        } else if (token.getNoTabsBefore() != 0) {
            this.addHit(parserPath, token.getLineNumber(), "You should not use tabs for indentation!", null);
        } else if (token.getNoSpacesBefore() != moduleIndentation) {
            this.addHit(parserPath, token.getLineNumber(), "The closing paranthesis of the ports list should have the same indentation as the module declaration!", null);
        }
    }

    private void checkPortsAndParameters(RfNamedElement module, ParserPath parserPath) {
        int lastCheckedLine = module.getLine();
        if (!(module instanceof RfModule)) {
            return;
        }
        List<RfField> parameters = module.getLocalParameters(384);
        for (RfField parameter : parameters) {
            if (!parameter.isInParameterPortList()) continue;
            this.hasParameters = true;
            if (parameter.getLine() != lastCheckedLine) continue;
            this.addHit(parserPath, parameter.getLine(), "Parameters must each be declared on their own line!", null);
        }
        List<IRfPortElement> ports = ((RfModule)module).getLocalPorts();
        for (IRfPortElement port : ports) {
            this.hasPorts = true;
            if (port.getLine() != lastCheckedLine) continue;
            this.addHit(parserPath, port.getLine(), "Ports must each be declared on their own line!", null);
        }
    }
}

