/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.9")
@CheckID(value="R.1203")
@CheckName(value="R.1203")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.SELECT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Check index value before access")
@CheckDescription(value="This rule requires indexes of dynamic array accesses to be checked before usage by an assertion, if statement, for loop, or ternary conditional operator.\nThe size checking has to be made with either one of the functions array.size() and $size(array). Signed indexes have to also be checked to be greater or equal to zero.\n\nExamples:\n\nx = array[index];  // NOT ALLOWED\nif (index < array.size() && index <= 0)\n  x = array[index]; // ALLOWED\n\nx = array[u_index];  // NOT ALLOWED\nassert(u_index < array.size());\nx = array[u_index];  // ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1203
extends OVMComplianceCheck {
    private Map<ParserPath, List<RfHid>> hidsToHit;
    private Map<ParserPath, Set<HidOccurrence>> occurencesToHit;
    private Map<ParserPath, List<DVTPair<IHidObject, RfNamedElement>>> assertConditions;

    public Check_R_1203(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.hidsToHit = new HashMap<ParserPath, List<RfHid>>();
        this.occurencesToHit = new HashMap<ParserPath, Set<HidOccurrence>>();
        this.assertConditions = new HashMap<ParserPath, List<DVTPair<IHidObject, RfNamedElement>>>();
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllAssertsExpects()) {
            ParserPath parserPath = rfNamedElement.getFile().getParserPath();
            if (this.checkPreWaivers(parserPath)) continue;
            this.notifyCheckAlive();
            RfAssertExpect assertionExpect = (RfAssertExpect)rfNamedElement;
            List<RfActionBlock> actionBlocks = assertionExpect.getLocalMembers(RfActionBlock.class);
            if (actionBlocks != null) continue;
            IHidObject conditionalExpression = assertionExpect.getExpression();
            RfNamedElement scope = assertionExpect.getEnclosingScope();
            if (this.assertConditions.get(parserPath) == null) {
                this.assertConditions.put(parserPath, new ArrayList());
            }
            List<DVTPair<IHidObject, RfNamedElement>> assertExpressions = this.assertConditions.get(parserPath);
            assertExpressions.add((DVTPair<IHidObject, RfNamedElement>)new DVTPair((Object)conditionalExpression, (Object)scope));
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
        for (Map.Entry entry : this.hidsToHit.entrySet()) {
            ParserPath path = (ParserPath)entry.getKey();
            for (RfHid hid : (List)entry.getValue()) {
                this.addHit(path, hid, "Illegal array access without check at \"" + hid.getName() + "\"!");
            }
        }
    }

    public int isComparisonOperator(RfHidOperator hid) {
        String op = hid.getOperatorText();
        if (op.equals("<") || op.equals("<=")) {
            return 1;
        }
        if (op.equals(">") || op.equals(">=")) {
            return 2;
        }
        if (op.equals("inside")) {
            return 3;
        }
        return 0;
    }

    public ComparatorType getComparatorType(RfHidOperator hid) {
        String op = hid.getOperatorText();
        if (op.equals("<") || op.equals(">")) {
            return ComparatorType.STRICT;
        }
        if (op.equals("<=") || op.equals(">=")) {
            return ComparatorType.EQUAL;
        }
        return ComparatorType.INSIDE;
    }

    private boolean isChecked(IHidObject conditionalExpression, IHidObject currentSelect, RfHid hid, boolean isIf) {
        int bigSideIndex;
        ArrayList smallSides = new ArrayList();
        ArrayList bigSides = new ArrayList();
        Predicate<IHidObject> splitOperatorSides = element -> {
            if (element instanceof RfHidOperator) {
                RfHidOperator op = (RfHidOperator)element;
                int opNumber = this.isComparisonOperator(op);
                if (opNumber == 0) {
                    return true;
                }
                if (opNumber == 1) {
                    smallSides.add(new MyPair<IHidObject, ComparatorType>(op.getLHValue(), this.getComparatorType(op)));
                    bigSides.add(new MyPair<IHidObject, ComparatorType>((IHidObject)op.getRHValues().get(0), this.getComparatorType(op)));
                } else if (opNumber == 2) {
                    smallSides.add(new MyPair<IHidObject, ComparatorType>((IHidObject)op.getRHValues().get(0), this.getComparatorType(op)));
                    bigSides.add(new MyPair<IHidObject, ComparatorType>(op.getLHValue(), this.getComparatorType(op)));
                } else if (opNumber == 3) {
                    RfHidOperator insideArgs = (RfHidOperator)op.getFirstRHValue();
                    IHidObject rightInside = insideArgs.getFirstRHValue();
                    IHidObject leftInside = insideArgs.getLHValue();
                    if (!(leftInside instanceof RfHidImplicit)) {
                        return true;
                    }
                    if (!((RfHidImplicit)leftInside).getName().equals("0")) {
                        return true;
                    }
                    smallSides.add(new MyPair<IHidObject, ComparatorType>(op.getLHValue(), this.getComparatorType(op)));
                    bigSides.add(new MyPair<IHidObject, ComparatorType>(rightInside, this.getComparatorType(op)));
                }
            }
            return true;
        };
        HidUtils.flattenToObjects(splitOperatorSides, (IHidObject)conditionalExpression, EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));
        if (!smallSides.contains(new MyPair<IHidObject, ComparatorType>(currentSelect, ComparatorType.ANY))) {
            return false;
        }
        boolean isSigned = false;
        RfHid tmpSelect = null;
        if (currentSelect instanceof RfHidOperator) {
            return false;
        }
        if (currentSelect instanceof RfHidAccess) {
            tmpSelect = (RfHid)((RfHidAccess)currentSelect).getParentHid();
        }
        if (currentSelect instanceof RfHid) {
            tmpSelect = (RfHid)currentSelect;
        }
        if (tmpSelect != null) {
            IRfNamedElement element2 = tmpSelect.getElement();
            if (!(element2 instanceof RfField)) {
                return false;
            }
            RfField fieldSelect = (RfField)element2;
            boolean bl = isSigned = fieldSelect.getDataType() != null && isIf && LintUtils.isSigned(fieldSelect.getDataType());
        }
        if ((bigSideIndex = smallSides.indexOf(new MyPair<IHidObject, ComparatorType>(currentSelect, ComparatorType.ANY))) < 0) {
            return false;
        }
        if (isSigned) {
            int smallSideIndex = bigSides.indexOf(new MyPair<IHidObject, ComparatorType>(currentSelect, ComparatorType.ANY));
            if (smallSideIndex < 0) {
                return false;
            }
            if (((MyPair)((Object)bigSides.get(smallSideIndex))).getValue() != ComparatorType.EQUAL) {
                return false;
            }
            IHidObject smallSide = (IHidObject)((MyPair)((Object)smallSides.get(smallSideIndex))).getKey();
            if (!(smallSide instanceof HidImplicit)) {
                return false;
            }
            HidImplicit implicitCompare = (HidImplicit)smallSide;
            if (!implicitCompare.getName().equals("0")) {
                return false;
            }
        }
        IHidObject bigSide = (IHidObject)((MyPair)((Object)bigSides.get(bigSideIndex))).getKey();
        ComparatorType type = (ComparatorType)((Object)((MyPair)((Object)bigSides.get(bigSideIndex))).getValue());
        if (type == ComparatorType.EQUAL || type == ComparatorType.INSIDE) {
            if (!(bigSide instanceof RfHidOperator)) {
                return false;
            }
            RfHidOperator bigInside = (RfHidOperator)bigSide;
            if (bigInside.getOperatorType() != 467) {
                return false;
            }
            IHidObject left = bigInside.getLHValue();
            IHidObject right = (IHidObject)bigInside.getRHValues().get(0);
            if (!(right instanceof HidImplicit)) {
                return false;
            }
            if (!((HidImplicit)right).getName().equals("1")) {
                return false;
            }
            bigSide = left;
        }
        if (!(bigSide instanceof RfHidAccessArgs)) {
            return false;
        }
        Hid bigSideHid = ((RfHidAccessArgs)bigSide).getParentHid();
        if (bigSideHid == null || !(bigSideHid.getElement() instanceof RfPredefinedFunction)) {
            return false;
        }
        if (bigSideHid.getElement().getName().equals("$size")) {
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)bigSideHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return false;
            }
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    IHidObject value;
                    String fieldName;
                    IRfNamedElement key = (IRfNamedElement)entry.getKey();
                    if (!(key instanceof RfPredefinedField) || !(fieldName = key.getName()).equals("array_identifier_or_data_type") || !((value = (IHidObject)entry.getValue()) instanceof RfHid) || !((RfHid)value).equals((Object)hid)) continue;
                    return true;
                }
            }
        }
        return bigSideHid.getElement().getName().equals("size") && bigSideHid.getParentAccess().getParentHid().getElement().equals(hid.getElement());
    }

    private boolean isCheckedForEach(IHidObject conditionalExpression, IHidObject select, RfHid hid) {
        RfHidOperator foreachOperator = (RfHidOperator)conditionalExpression;
        IHidObject forEachVariable = foreachOperator.getLHValue();
        if (!(forEachVariable instanceof RfHidAccess)) {
            return false;
        }
        RfHidAccess conditionAccess = (RfHidAccess)forEachVariable;
        Hid conditionHid = conditionAccess.getParentHid();
        if (!(conditionHid instanceof RfHid)) {
            return false;
        }
        RfHid currHid = (RfHid)conditionHid;
        ListContainer accesses = currHid.getAccesses();
        if (accesses == null || accesses.isEmpty()) {
            return false;
        }
        List selects = ((HidAccess)accesses.get(0)).getSelects();
        if (selects == null) {
            return false;
        }
        IRfNamedElement arrayElement = currHid.getElement();
        if (arrayElement == null || !(arrayElement instanceof RfField)) {
            return false;
        }
        IRfNamedElement asocType = ((RfField)arrayElement).getAssociatedType();
        if (!(asocType instanceof RfListType) || !((RfListType)asocType).isDynamicArray()) {
            return false;
        }
        if (!arrayElement.equals(hid.getElement())) {
            return false;
        }
        IHidObject conditionSelect = (IHidObject)selects.get(0);
        if (!(conditionSelect instanceof RfHid)) {
            return false;
        }
        RfHid conditionSelectHid = (RfHid)conditionSelect;
        IRfNamedElement selectElement = conditionSelectHid.getElement();
        if (selectElement == null || !(selectElement instanceof RfField)) {
            return false;
        }
        if (!(select instanceof RfHid)) {
            return false;
        }
        RfHid selectHid = (RfHid)select;
        return selectElement.equals(selectHid.getElement());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static enum ComparatorType {
        STRICT,
        EQUAL,
        INSIDE,
        ANY;

    }

    private class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        private LocalHidVisitor() {
        }

        public void setHolder(IHidHolder holder) {
            if (holder instanceof RfHidHolder) {
                this.scope = ((RfHidHolder)holder).getScope();
            }
        }

        public boolean visit(IHidObject hidObject) {
            if (Check_R_1203.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1203.this.notifyCheckAlive();
            if (hidObject instanceof RfHid) {
                Set<HidOccurrence> occurences;
                IRfNamedElement localScope;
                IHidObject conditionalExpression;
                List<DVTPair<IHidObject, RfNamedElement>> assertsInFile;
                RfHid hid = (RfHid)hidObject;
                ListContainer accesses = hid.getAccesses();
                if (accesses == null) {
                    return true;
                }
                List selects = HidUtils.getSelects((IHidObject)((IHidObject)accesses.get(0)));
                if (selects == null || selects.isEmpty()) {
                    return true;
                }
                IRfNamedElement arrayElement = hid.getElement();
                if (arrayElement == null || !(arrayElement instanceof RfField)) {
                    return true;
                }
                IRfNamedElement asocType = ((RfField)arrayElement).getAssociatedType();
                if (!(asocType instanceof RfListType) || !((RfListType)asocType).isDynamicArray()) {
                    return true;
                }
                IHidObject select = (IHidObject)selects.get(0);
                if (select instanceof RfHidOperator) {
                    RfHidOperator selectOperator = (RfHidOperator)select;
                    if (selectOperator.getOperatorType() != 467) {
                        return true;
                    }
                    if (selectOperator.getRHValues() != null) {
                        return true;
                    }
                    if (!(selectOperator.getLHValue() instanceof RfHidImplicit)) {
                        return true;
                    }
                }
                if ((assertsInFile = Check_R_1203.this.assertConditions.get(this.parserPath)) != null && !assertsInFile.isEmpty()) {
                    for (DVTPair<IHidObject, RfNamedElement> conditionAndScope : assertsInFile) {
                        conditionalExpression = (IHidObject)conditionAndScope.getKey();
                        RfNamedElement expressionScope = (RfNamedElement)conditionAndScope.getValue();
                        boolean sameScope = false;
                        localScope = this.scope;
                        while (localScope != null) {
                            if (localScope == expressionScope) {
                                sameScope = true;
                                break;
                            }
                            localScope = (IRfNamedElement)localScope.getEnclosingScope();
                        }
                        if (!sameScope || !(conditionalExpression instanceof RfHidOperator) || ((RfHidOperator)conditionalExpression).getLine() >= hid.getLine() || !Check_R_1203.this.isChecked(conditionalExpression, select, hid, true)) continue;
                        Check_R_1203.this.occurencesToHit.get(this.parserPath).add(hid.getOccurrence());
                    }
                }
                if ((occurences = Check_R_1203.this.occurencesToHit.get(this.parserPath)) != null && occurences.contains(hid.getOccurrence())) {
                    return true;
                }
                localScope = this.scope;
                boolean isGuardedSelect = false;
                while (localScope != null && !isGuardedSelect) {
                    if (localScope instanceof RfActionBlock) {
                        if (((RfActionBlock)localScope).isConditionalWithExpression()) {
                            conditionalExpression = (IHidObject)((ListContainer)((RfActionBlock)localScope).getHidHolder().getHidObjectsMap().get(this.parserPath)).get(0);
                            isGuardedSelect = Check_R_1203.this.isChecked(conditionalExpression, select, hid, true);
                        }
                        if (((RfActionBlock)localScope).isForOrForeach()) {
                            ListContainer expression = (ListContainer)((RfActionBlock)localScope).getHidHolder().getHidObjectsMap().get(this.parserPath);
                            String operatorText = ((RfActionBlock)localScope).isFor() ? "for" : "foreach";
                            ArrayList<IHidObject> conditionalExpressions = new ArrayList<IHidObject>();
                            for (IHidObject exp : expression) {
                                if (!(exp instanceof RfHidOperator) || !((RfHidOperator)exp).hasOccurrence(HidOperatorQualifier.IS_LOOP_EXPRESSION.value()) || !((RfHidOperator)exp).getOperatorText().equals(operatorText)) continue;
                                conditionalExpressions.add(exp);
                            }
                            isGuardedSelect = operatorText.equals("for") ? Check_R_1203.this.isChecked((IHidObject)conditionalExpressions.get(0), select, hid, false) : Check_R_1203.this.isCheckedForEach((IHidObject)conditionalExpressions.get(0), select, hid);
                        }
                    }
                    localScope = (IRfNamedElement)localScope.getEnclosingScope();
                }
                if (Check_R_1203.this.hidsToHit.get(this.parserPath) == null) {
                    Check_R_1203.this.hidsToHit.put(this.parserPath, new ArrayList());
                }
                List<RfHid> hitHids = Check_R_1203.this.hidsToHit.get(this.parserPath);
                if (Check_R_1203.this.occurencesToHit.get(this.parserPath) == null) {
                    Check_R_1203.this.occurencesToHit.put(this.parserPath, new HashSet());
                }
                Set<HidOccurrence> occurencesHitLocal = Check_R_1203.this.occurencesToHit.get(this.parserPath);
                if (!isGuardedSelect) {
                    if (select instanceof RfHid) {
                        hitHids.add((RfHid)select);
                    }
                    if (select instanceof RfHidAccess) {
                        hitHids.add((RfHid)((RfHidAccess)select).getParentHid());
                    }
                    if (select instanceof RfHidImplicit || select instanceof RfHidOperator) {
                        hitHids.add(hid);
                    }
                    occurencesHitLocal.add(hid.getOccurrence());
                }
                return true;
            }
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (!hidOperator.isConditionalTernary()) {
                    return true;
                }
                if (Check_R_1203.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (Check_R_1203.this.occurencesToHit.get(this.parserPath) == null) {
                    Check_R_1203.this.occurencesToHit.put(this.parserPath, new HashSet());
                }
                Set<HidOccurrence> occurencesLocal = Check_R_1203.this.occurencesToHit.get(this.parserPath);
                IHidObject conditionalExpression = hidOperator.getLHValue();
                ArrayList hidsToCheck = new ArrayList();
                ListContainer rhValues = hidOperator.getRHValues();
                Predicate<IHidObject> filterHids = element -> {
                    if (!(element instanceof RfHidOperator)) {
                        if (element instanceof RfHidAccess) {
                            hidsToCheck.add(((RfHidAccess)((Object)element)).getParentHid());
                        } else {
                            hidsToCheck.add(element);
                        }
                    }
                    return true;
                };
                for (IHidObject val : rhValues) {
                    HidUtils.flattenToObjects(filterHids, (IHidObject)val, (Set)HidFlatteningOption.IMPLICITS_AND_SELECT_OBJECTS_EXCLUDED);
                }
                for (IHidObject rhHid : hidsToCheck) {
                    IHidObject select;
                    IRfNamedElement asocType;
                    IRfNamedElement arrayElement;
                    List selects;
                    RfHid hid;
                    ListContainer accesses;
                    if (!(rhHid instanceof RfHid) || (accesses = (hid = (RfHid)rhHid).getAccesses()) == null || accesses.isEmpty() || (selects = ((HidAccess)accesses.get(0)).getSelects()) == null || (arrayElement = hid.getElement()) == null || !(arrayElement instanceof RfField) || !((asocType = ((RfField)arrayElement).getAssociatedType()) instanceof RfListType) || !((RfListType)asocType).isDynamicArray() || !Check_R_1203.this.isChecked(conditionalExpression, select = (IHidObject)selects.get(0), hid, false)) continue;
                    if (!occurencesLocal.contains(hid.getOccurrence())) {
                        occurencesLocal.add(hid.getOccurrence());
                        continue;
                    }
                    List<RfHid> hitHidsLocal = Check_R_1203.this.hidsToHit.get(this.parserPath);
                    if (select instanceof RfHid) {
                        hitHidsLocal.remove(select);
                    }
                    if (select instanceof RfHidAccess) {
                        hitHidsLocal.remove(((RfHidAccess)select).getParentHid());
                    }
                    if (!(select instanceof RfHidImplicit) && !(select instanceof RfHidOperator)) continue;
                    hitHidsLocal.remove((Object)hid);
                }
                return true;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private static class MyPair<K, V>
    extends DVTPair<K, V> {
        public MyPair(K key, V value) {
            super(key, value);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DVTPair)) {
                return false;
            }
            DVTPair other = (DVTPair)obj;
            return !(this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey()));
        }
    }
}

