/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.8")
@CheckID(value="R.1204")
@CheckName(value="R.1204")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.OVERRIDE, RuleLabel.COMPONENT, RuleLabel.SUPER, RuleLabel.VERIFICATION, RuleLabel.PHASE})
@CheckTitle(value="Overridden component phases must call super")
@CheckDescription(value="All classes that inherit from xvm_component and implement any phase method must call super of that method.\n\nExamples:\n\nclass child extends uvm_component;\n  function void build_phase(uvm_phase phase); \n    super.build_phase(phase); // allowed\n  endfunction\n  function void final_phase(uvm_phase phase); // not allowed\n  endfunction \nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1204
extends OVMComplianceCheck {
    private String baseClassValue;
    private Set<String> methodNames;
    private boolean superFound;

    public Check_R_1204(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.methodNames = LintUtilsConstants.OVM_COMPONENT_PHASES_NAMES;
            this.baseClassValue = "ovm_pkg::ovm_component";
        } else if (this.fOVMProject.getLibraryKind() == 2) {
            this.methodNames = LintUtilsConstants.UVM_COMPONENT_PHASES_NAMES;
            this.baseClassValue = "uvm_pkg::uvm_component";
        }
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.baseClassValue, true);
        if (baseClass == null) {
            this.addHit(null, "Class '" + this.baseClassValue + "' not found!");
            return;
        }
        Set<RfClass> allComponents = this.fOVMProject.getAllXVMSubClasses(baseClass);
        if (allComponents.isEmpty()) {
            return;
        }
        this.checkComponents(allComponents);
    }

    private void checkComponents(Set<RfClass> allComponents) {
        for (RfClass component : allComponents) {
            if (this.checkPreWaivers(component.getFile())) continue;
            this.notifyCheckAlive();
            this.checkSuperCallsInClass(component);
        }
    }

    private void checkSuperCallsInClass(RfClass component) {
        List<RfFunction> localMembers = component.getLocalMembers(RfFunction.class);
        for (final RfFunction localMember : localMembers) {
            if (!this.methodNames.contains(localMember.getName())) continue;
            this.superFound = false;
            localMember.visitHidObject(null, new RfHidVisitor(){

                public boolean visit(RfHid hidObject) {
                    if (hidObject == null) {
                        return true;
                    }
                    if (hidObject.getElement() == null) {
                        return true;
                    }
                    if (hidObject.getElement().getName() == null) {
                        return true;
                    }
                    if (!hidObject.getElement().getName().equals(localMember.getName())) {
                        return true;
                    }
                    if (hidObject.getParentHid() == null) {
                        return true;
                    }
                    Hid parentHid = hidObject.getParentHid();
                    if (parentHid.getElement() instanceof RfSuperImplicitVariable) {
                        Check_R_1204.this.superFound = true;
                        return false;
                    }
                    return true;
                }
            });
            if (this.superFound) continue;
            this.addHit(localMember, "'" + LintUtils.getNamedElementFullName(localMember) + "()' does not call 'super." + localMember.getName() + "()'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

