/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.8")
@CheckID(value="R.1205")
@CheckName(value="R.1205")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.DESIGN, RuleLabel._4_STATE})
@CheckTitle(value="Do not use literal X")
@CheckDescription(value="Using X literals in RTL code is not allowed to ignore invalid states.\n\nExamples:\n  signal_AB <= 1'bx; // NOT ALLOWED\n  signal_AB <= 1'b1;  // ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1205
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    public Check_R_1205(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidOperator>(){
            ParserPath parserPath;

            public boolean visit(IHidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                if (Check_R_1205.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1205.this.notifyCheckAlive();
                Set hids = hidOperator.getLHHids(EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
                hids.addAll(hidOperator.getRHHids(EnumSet.of(HidFlatteningOption.IGNORE_HIDS)));
                for (IHid hid : hids) {
                    if (!(hid instanceof RfHidImplicit) || !((RfHidImplicit)hid).isNumber() || !((RfHidImplicit)hid).getName().toLowerCase().contains("x")) continue;
                    Check_R_1205.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Forbiden use of x state in literal '" + ((RfHidImplicit)hid).getName() + "'!");
                }
                return true;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidOperator> getType() {
                return IHidOperator.class;
            }
        });
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

