/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;

@CheckVersion(value="23.1.8")
@CheckID(value="R.1206")
@CheckName(value="R.1206")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.SELECT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Check index value before access for associative arrays")
@CheckDescription(value="This rule ensures that there are no accesses or deletions of indexes that might not exist in the associative array.\n\nExamples:\nfunction f;\n  int h1[string] = '{default:1};\n  int h2[string];\n  int x = h1[\"a\"]; // allowed because of the array default value\n  int y = h2[\"a\"]; // not allowed\n  h1.delete(\"a\"); // not allowed\n  if (h2.exists(\"a\") begin\n    h2.delete(\"a\"); // allowed\n    y = h2[\"a\"]; // allowed\n  end\n  y = (h2.exists(\"a\")) ? h2[\"a\"] : 0; // allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1206
extends OVMComplianceCheck {
    private static final String MINUS = "-";
    @CheckParameter(defaultValue="false", description="When true, accesses and deletions from constraints will be skipped.", name="skipAccessesInConstraints", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipAccessesInConstraints;
    @CheckParameter(defaultValue="", description="Comma separated list of literal index values which are allowed to be accessed without checking their existance beforehand.", name="allowedLiterals", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedLiterals;

    public Check_R_1206(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final HashMap checkedHidsMap = new HashMap();
        final HashMap scopeToIfElseMap = new HashMap();
        final HashMap associativeArrayWithDefaultToScopesMap = new HashMap();
        final ArrayList<String> negativeLiterals = new ArrayList<String>();
        for (String literal : this.pAllowedLiterals) {
            if (!literal.startsWith(MINUS)) continue;
            String negativeLiteral = literal.substring(1).trim();
            negativeLiterals.add(negativeLiteral);
        }
        HidOperatorVisitor conditionalTernaryVisitor = new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (!hidOperator.isConditionalTernary()) {
                    return true;
                }
                if (Check_R_1206.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1206.this.notifyCheckAlive();
                if (checkedHidsMap.get(this.parserPath) == null) {
                    checkedHidsMap.put(this.parserPath, new HashSet());
                }
                Set checkedHids = (Set)checkedHidsMap.get(this.parserPath);
                ArrayList leftHids = new ArrayList();
                Predicate<IHidObject> condition = element -> {
                    if (element instanceof RfHidAccessArgs) {
                        leftHids.add(element);
                    }
                    return true;
                };
                IHidObject lhValue = hidOperator.getLHValue();
                HidUtils.flattenToObjects(condition, (IHidObject)lhValue, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                block0: for (IHidObject rhHid : hidOperator.getRHValues()) {
                    IHidObject index;
                    List selects;
                    HidAccess firstAccess;
                    ListContainer accesses;
                    IRfNamedElement fieldAssocType;
                    IRfNamedElement hidElement;
                    Hid associativeArray;
                    if (!(rhHid instanceof RfHidAccess) || (associativeArray = ((RfHidAccess)rhHid).getParentHid()) == null || !(associativeArray instanceof RfHid) || !((hidElement = associativeArray.getElement()) instanceof RfField) || !((fieldAssocType = ((RfField)hidElement).getAssociatedType()) instanceof RfListType) || !((RfListType)fieldAssocType).isAssociativeArray() || (accesses = associativeArray.getAccesses()) == null || accesses.isEmpty() || (firstAccess = (HidAccess)accesses.get(0)) == null || (selects = firstAccess.getSelects()) == null || selects.isEmpty() || (index = (IHidObject)selects.get(0)) == null) continue;
                    if (Check_R_1206.this.pAllowedLiterals.contains(index.toString())) {
                        checkedHids.add(associativeArray.toString());
                        continue;
                    }
                    for (IHidObject leftHid : leftHids) {
                        if (!Check_R_1206.this.checkMethod(leftHid, associativeArray, index)) continue;
                        checkedHids.add(associativeArray.toString());
                        continue block0;
                    }
                }
                return true;
            }
        };
        IHidVisitor<IHidObject> hidVisitor = new IHidVisitor<IHidObject>(){
            boolean checkNextAssignmentOp;
            ParserPath parserPath;
            private IRfNamedElement scope;
            Set<String> checkedHids;

            public void setHolder(IHidHolder holder) {
                if (holder instanceof RfHidHolder) {
                    this.scope = ((RfHidHolder)holder).getScope();
                }
                scopeToIfElseMap.put(this.scope, new HashMap());
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
                this.checkedHids = (Set)checkedHidsMap.get(parserPath);
            }

            public void endScope(IRfNamedElement scope) {
                scopeToIfElseMap.remove(scope);
                super.endScope(scope);
            }

            public boolean visit(IHidObject hidObject) {
                if (Check_R_1206.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1206.this.notifyCheckAlive();
                if (Check_R_1206.this.pSkipAccessesInConstraints && this.scope.getEnclosingScope(RfConstraint.class) != null) {
                    return true;
                }
                if (hidObject instanceof RfHidOperator) {
                    RfHidOperator hidOperator = (RfHidOperator)hidObject;
                    if (hidOperator.isAssociation()) {
                        IHidObject lhValue = hidOperator.getLHValue();
                        if (lhValue == null) {
                            return true;
                        }
                        if (lhValue.toString().equals("default")) {
                            this.checkNextAssignmentOp = true;
                        }
                    } else if (this.checkNextAssignmentOp && hidOperator.isAssignment()) {
                        ListContainer rhValues = hidOperator.getRHValues();
                        if (rhValues == null || rhValues.isEmpty()) {
                            return true;
                        }
                        if (rhValues.get(0) instanceof RfHidOperator) {
                            RfHidOperator rhOperator = (RfHidOperator)rhValues.get(0);
                            if (!rhOperator.isAssignmentPattern()) {
                                return true;
                            }
                            IHidObject lhValue = hidOperator.getLHValue();
                            if (lhValue == null) {
                                return true;
                            }
                            DVTPair associativeArray = new DVTPair((Object)this.parserPath, (Object)lhValue.toString());
                            HashSet<IRfNamedElement> scopes = (HashSet<IRfNamedElement>)associativeArrayWithDefaultToScopesMap.get(associativeArray);
                            if (scopes == null) {
                                scopes = new HashSet<IRfNamedElement>();
                                associativeArrayWithDefaultToScopesMap.put(associativeArray, scopes);
                            }
                            scopes.add(this.scope);
                        }
                    }
                } else {
                    if (hidObject instanceof RfHidAccessArgs) {
                        String negativeLiteral;
                        IHidObject negativeValue;
                        RfHidOperator indexOperator;
                        RfHidAccessArgs methodHid = (RfHidAccessArgs)hidObject;
                        Hid method = methodHid.getParentHid();
                        if (method == null) {
                            return true;
                        }
                        IRfNamedElement methodElement = method.getElement();
                        if (!(methodElement instanceof RfPredefinedFunction) || !methodElement.getName().equals("delete")) {
                            return true;
                        }
                        HidAccess accessArrayHid = method.getParentAccess();
                        if (accessArrayHid == null) {
                            return true;
                        }
                        IRfNamedElement accessArrayType = accessArrayHid.getAssociatedType();
                        if (!(accessArrayType instanceof RfListType) || !((RfListType)accessArrayType).isAssociativeArray()) {
                            return true;
                        }
                        Hid accessArray = accessArrayHid.getParentHid();
                        if (accessArray == null) {
                            return true;
                        }
                        List<? extends IHidObject> argumentValues = methodHid.getArgumentValues();
                        if (argumentValues == null || argumentValues.size() != 1) {
                            return true;
                        }
                        RfHidOperator args = (RfHidOperator)argumentValues.get(0);
                        if (args == null) {
                            return true;
                        }
                        ListContainer rhValues = args.getRHValues();
                        if (rhValues == null || rhValues.isEmpty()) {
                            return true;
                        }
                        IHidObject index = (IHidObject)rhValues.get(0);
                        if (index == null) {
                            return true;
                        }
                        String indexString = index.toString();
                        if (index instanceof RfHidOperator ? (indexOperator = (RfHidOperator)index).getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR && indexOperator.isMinus() && (negativeValue = indexOperator.getLHValue()) instanceof RfHidImplicit && negativeLiterals.contains(negativeLiteral = ((RfHidImplicit)negativeValue).getName()) : Check_R_1206.this.pAllowedLiterals.contains(indexString)) {
                            return true;
                        }
                        IRfNamedElement localScope = this.scope;
                        boolean isChecked = this.isAccessChecked(accessArray, index, localScope);
                        if (isChecked) {
                            return true;
                        }
                        if (index instanceof RfHid) {
                            indexString = ((RfHid)index).getName();
                        }
                        Check_R_1206.this.addHit(this.parserPath, (HidOccurrence)args.getOccurrence(), "You must check if the value '" + accessArray.getName() + "[" + indexString + "]' exists before trying to delete it!");
                        return true;
                    }
                    if (hidObject instanceof RfHid) {
                        String negativeLiteral;
                        IHidObject negativeValue;
                        RfHidOperator indexOperator;
                        RfHid hid = (RfHid)hidObject;
                        IRfNamedElement hidElement = hid.getElement();
                        if (!(hidElement instanceof RfField)) {
                            return true;
                        }
                        IRfNamedElement fieldAssocType = ((RfField)hidElement).getAssociatedType();
                        if (!(fieldAssocType instanceof RfListType) || !((RfListType)fieldAssocType).isAssociativeArray()) {
                            return true;
                        }
                        ListContainer accesses = hid.getAccesses();
                        if (accesses == null) {
                            return true;
                        }
                        HidAccess firstAccess = (HidAccess)accesses.get(0);
                        if (firstAccess == null) {
                            return true;
                        }
                        List selects = firstAccess.getSelects();
                        if (selects == null) {
                            return true;
                        }
                        IHidObject index = (IHidObject)selects.get(0);
                        if (index == null) {
                            return true;
                        }
                        String indexString = index.toString();
                        if (this.checkedHids != null && this.checkedHids.contains(hid.toString())) {
                            return true;
                        }
                        if (index instanceof RfHidOperator ? (indexOperator = (RfHidOperator)index).getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR && indexOperator.isMinus() && (negativeValue = indexOperator.getLHValue()) instanceof RfHidImplicit && negativeLiterals.contains(negativeLiteral = ((RfHidImplicit)negativeValue).getName()) : Check_R_1206.this.pAllowedLiterals.contains(indexString)) {
                            return true;
                        }
                        String associativeArrayName = hid.getName();
                        DVTPair associativeArrayPair = new DVTPair((Object)this.parserPath, (Object)associativeArrayName);
                        boolean hasDefault = false;
                        Set scopes = (Set)associativeArrayWithDefaultToScopesMap.get(associativeArrayPair);
                        if (scopes != null && !scopes.isEmpty()) {
                            for (IRfNamedElement potentialParentScope : scopes) {
                                if (!VlogRfReferencesUtils.isChildOfScope(potentialParentScope, (RfNamedElement)this.scope, associativeArrayName)) continue;
                                hasDefault = true;
                            }
                        }
                        if (hasDefault) {
                            return true;
                        }
                        IRfNamedElement localScope = this.scope;
                        boolean isChecked = this.isAccessChecked(hid, index, localScope);
                        if (isChecked) {
                            return true;
                        }
                        if (index instanceof RfHid) {
                            indexString = ((RfHid)index).getName();
                        }
                        Check_R_1206.this.addHit(this.parserPath, hid, "You must check if the value '" + hidElement + "[" + indexString + "]' exists before trying to access it!");
                    }
                }
                return true;
            }

            private boolean isAccessChecked(Hid accessArray, IHidObject index, IRfNamedElement localScope) {
                while (localScope != null) {
                    if (localScope instanceof RfAssertExpect) {
                        IHidObject assertExpression = ((RfAssertExpect)localScope).getExpression();
                        ArrayList assertExpressionHids = new ArrayList();
                        Predicate<IHidObject> cons = element -> {
                            if (!(element instanceof RfHidOperator)) {
                                assertExpressionHids.add(element);
                            }
                            return true;
                        };
                        HidUtils.flattenToObjects(cons, (IHidObject)assertExpression, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                        for (IHidObject assertHid : assertExpressionHids) {
                            if (!(assertHid instanceof RfHidAccessArgs) || !Check_R_1206.this.checkMethod(assertHid, accessArray, index)) continue;
                            return true;
                        }
                    } else if (localScope instanceof RfActionBlock) {
                        RfActionBlock correspondingIf = (RfActionBlock)localScope;
                        if (((RfActionBlock)localScope).isElse()) {
                            Map ifElseMap = (Map)scopeToIfElseMap.get(localScope);
                            if (ifElseMap == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            if (ifElseMap.isEmpty()) {
                                this.populateIfElseMap(localScope, ifElseMap);
                            }
                            if ((correspondingIf = (RfActionBlock)ifElseMap.get(localScope)) == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                        }
                        if (correspondingIf.isConditionalWithExpression()) {
                            hidHolder = correspondingIf.getHidHolder();
                            if (hidHolder == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            hidObjectsMap = hidHolder.getHidObjectsMap();
                            if (hidObjectsMap == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            hidObjects = (ListContainer)hidObjectsMap.get(this.parserPath);
                            if (hidObjects == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            IHidObject conditionalExpression = (IHidObject)hidObjects.get(0);
                            if (conditionalExpression == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            ArrayList conditionalExpressionHids = new ArrayList();
                            cons = element -> {
                                if (!(element instanceof RfHidOperator)) {
                                    conditionalExpressionHids.add(element);
                                }
                                return true;
                            };
                            HidUtils.flattenToObjects(cons, (IHidObject)conditionalExpression, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                            for (IHidObject conditionalHid : conditionalExpressionHids) {
                                if (!(conditionalHid instanceof RfHidAccessArgs) || !Check_R_1206.this.checkMethod(conditionalHid, accessArray, index)) continue;
                                return true;
                            }
                        } else if (((RfActionBlock)localScope).isForEach()) {
                            hidHolder = correspondingIf.getHidHolder();
                            if (hidHolder == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            hidObjectsMap = hidHolder.getHidObjectsMap();
                            if (hidObjectsMap == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            hidObjects = (ListContainer)hidObjectsMap.get(this.parserPath);
                            if (hidObjects == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            IHidObject loopExpression = (IHidObject)hidObjects.get(0);
                            if (loopExpression == null) {
                                localScope = (IRfNamedElement)localScope.getEnclosingScope();
                                continue;
                            }
                            ArrayList loopExpressionHids = new ArrayList();
                            cons = element -> {
                                if (!(element instanceof RfHidOperator)) {
                                    loopExpressionHids.add(element);
                                }
                                return true;
                            };
                            HidUtils.flattenToObjects(cons, (IHidObject)loopExpression, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                            for (IHidObject loopHid : loopExpressionHids) {
                                List selects;
                                HidAccess firstAccess;
                                ListContainer accesses;
                                IRfNamedElement fieldAssocType;
                                RfHid hid;
                                IRfNamedElement hidElement;
                                if (!(loopHid instanceof RfHid) || !((hidElement = (hid = (RfHid)loopHid).getElement()) instanceof RfField) || !((fieldAssocType = ((RfField)hidElement).getAssociatedType()) instanceof RfListType) || !((RfListType)fieldAssocType).isAssociativeArray() || (accesses = hid.getAccesses()) == null || (firstAccess = (HidAccess)accesses.get(0)) == null || (selects = firstAccess.getSelects()) == null) continue;
                                IHidObject loopIndex = (IHidObject)selects.get(0);
                                IRfNamedElement accessArrayElement = accessArray.getElement();
                                IRfNamedElement loopAssociativeArrayElement = hid.getElement();
                                if (accessArrayElement == null || loopAssociativeArrayElement == null) continue;
                                String indexString = index.toString();
                                String loopIndexString = loopIndex.toString();
                                if (index instanceof RfHid && loopIndex instanceof RfHid) {
                                    indexString = ((RfHid)index).getName();
                                    loopIndexString = ((RfHid)loopIndex).getName();
                                }
                                if (!loopIndexString.equals(indexString) || loopAssociativeArrayElement != accessArrayElement) continue;
                                return true;
                            }
                        }
                    }
                    localScope = (IRfNamedElement)localScope.getEnclosingScope();
                }
                return false;
            }

            private void populateIfElseMap(IRfNamedElement localScope, Map<RfActionBlock, RfActionBlock> ifElseMap) {
                IRfScopeElement enclosingScope = localScope.getEnclosingScope();
                if (!(enclosingScope instanceof RfNamedElement)) {
                    return;
                }
                RfNamedElement membersHolder = (RfNamedElement)enclosingScope;
                List<RfActionBlock> members = membersHolder.getLocalMembers(RfActionBlock.class);
                if (members == null || members.isEmpty()) {
                    return;
                }
                ArrayDeque<RfActionBlock> blocksWithoutMatchingElse = new ArrayDeque<RfActionBlock>();
                for (RfActionBlock member : members) {
                    if (member.isIf()) {
                        blocksWithoutMatchingElse.add(member);
                    }
                    if (member.isElsIf()) {
                        blocksWithoutMatchingElse.pop();
                        blocksWithoutMatchingElse.add(member);
                    }
                    if (!member.isElse() || blocksWithoutMatchingElse.isEmpty()) continue;
                    ifElseMap.put(member, (RfActionBlock)blocksWithoutMatchingElse.pop());
                }
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)conditionalTernaryVisitor);
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), hidVisitor);
    }

    private boolean checkMethod(IHidObject hidObject, Hid accessArray, IHidObject index) {
        RfHidAccessArgs methodHidCondition = (RfHidAccessArgs)hidObject;
        Hid methodCondition = methodHidCondition.getParentHid();
        if (methodCondition == null) {
            return false;
        }
        IRfNamedElement methodElementCondition = methodCondition.getElement();
        if (!(methodElementCondition instanceof RfPredefinedFunction) || !methodElementCondition.getName().equals("exists")) {
            return false;
        }
        HidAccess accessArrayHidCondition = methodCondition.getParentAccess();
        if (accessArrayHidCondition == null) {
            return false;
        }
        Hid accessArrayCondition = accessArrayHidCondition.getParentHid();
        if (accessArrayCondition == null) {
            return false;
        }
        IRfNamedElement accessArrayElement = accessArray.getElement();
        IRfNamedElement accessArrayConditionElement = accessArrayCondition.getElement();
        if (accessArrayElement == null || accessArrayConditionElement == null) {
            return false;
        }
        if (accessArrayConditionElement != accessArrayElement) {
            return false;
        }
        List<? extends IHidObject> argumentValuesCondition = methodHidCondition.getArgumentValues();
        if (argumentValuesCondition == null || argumentValuesCondition.size() != 1) {
            return false;
        }
        RfHidOperator argsCondition = (RfHidOperator)argumentValuesCondition.get(0);
        if (argsCondition == null) {
            return false;
        }
        ListContainer rhValuesConditon = argsCondition.getRHValues();
        if (rhValuesConditon == null || rhValuesConditon.isEmpty()) {
            return false;
        }
        IHidObject indexCondition = (IHidObject)rhValuesConditon.get(0);
        if (indexCondition == null) {
            return false;
        }
        boolean isChecked = indexCondition.toString().equals(index.toString());
        if (index instanceof RfHid && indexCondition instanceof RfHid) {
            isChecked = ((RfHid)index).getName().equals(((RfHid)indexCondition).getName());
        }
        return isChecked;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

