/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.16")
@CheckID(value="R.1207")
@CheckName(value="R.1207")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CASE, RuleLabel.CONDITIONAL})
@CheckTitle(value="Case item formatting")
@CheckDescription(value="Case items must follow the following formatting rules:\n - there must be no white space before a case item's colon;\n - there must be at least one space after the case item's colon;\n - the default case item must include a colon.\n\nExamples:\ncase (a)\n  0: $display(\"0\");        // allowed\n  1 : $display(\"1\");       // not allowed\n  2:$display(\"2\");         // not allowed\n  default $display(\"8\");   // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1207
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    public Check_R_1207(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        if (actionBlocks == null) {
            return;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            if (!actionBlock.isCase() || this.checkPreWaivers(actionBlock.getFile())) continue;
            this.notifyCheckAlive();
            Collection<RfNamedElement> members = actionBlock.getMembers();
            if (members == null || members.isEmpty()) continue;
            for (RfNamedElement member : members) {
                RfActionBlock block;
                if (!(member instanceof RfActionBlock) || !(block = (RfActionBlock)member).isCaseItem()) continue;
                block.visitHidObject(null, new IHidVisitor<RfHidOperator>(){

                    public boolean visit(RfHidOperator operator) {
                        if (operator.getReparseInfo() != null) {
                            return true;
                        }
                        if (!operator.isCaseItemCondition()) {
                            return true;
                        }
                        LiteralToken token = Check_R_1207.this.getWSParser().getTokenContainingOffset(operator.getOffset(), block.getFile().getParserPath());
                        if (token == null) {
                            return true;
                        }
                        String expectedToken = String.valueOf(block.getExpression()) + ":";
                        if (token.getStringToken().equals(expectedToken) && (token.getNoSpacesAfter() > 0 || token.getNoTabsAfter() > 0)) {
                            return true;
                        }
                        Check_R_1207.this.addHit(block, "Wrong formatting for case item '" + block.getExpression() + "'!");
                        return true;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

