/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="23.1.9")
@CheckID(value="R.1208")
@CheckName(value="R.1208")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CONDITIONAL, RuleLabel.IF, RuleLabel.BEGIN_END})
@CheckTitle(value="Else should be on the new line after end label")
@CheckDescription(value="When an if block has a name label, the else keyword must not be on the same line as the end label.\n\nExamples:\nif (a > 12) begin : testif\n   a = 12;\nend :testif else begin  // not allowed\n   a = 0;\nend\n\nif (a > 12) begin : testif\n   a = 12;\nend :testif             //allowed\nelse begin\n   a = 0;\nend\n\nCheck supports pre-waiving.")
public class Check_R_1208
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final Pattern END_ELSE_PARRERN = Pattern.compile(".*end,*:.*,else.*");

    public Check_R_1208(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(this.fOVMProject.getRfProject(), new LocalNamedElementVisitor());
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        private LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement element) {
            if (!(element instanceof RfActionBlock)) {
                return true;
            }
            ParserPath parserPath = element.getFile().getParserPath();
            if (Check_R_1208.this.checkPrewaivers(parserPath)) {
                return true;
            }
            Check_R_1208.this.notifyCheckAlive();
            RfActionBlock block = (RfActionBlock)element;
            if (!block.isIf() && !block.isElsIf()) {
                return true;
            }
            if (!block.isNamedBlock()) {
                return true;
            }
            DVTStringBuilder lineStringBuilder = new DVTStringBuilder();
            for (LiteralToken token : Check_R_1208.this.getWSParser().getTokensOnLine(parserPath, block.getEndLine())) {
                if (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE)) continue;
                lineStringBuilder.append(String.valueOf(token.getStringToken()) + ",");
            }
            String lineString = lineStringBuilder.toString();
            if (END_ELSE_PARRERN.matcher(lineString).matches()) {
                Check_R_1208.this.addHit(parserPath, block.getEndLine(), "Else should be on the new line after end label!", null);
            }
            return true;
        }
    }
}

