/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;

@CheckVersion(value="23.1.16")
@CheckID(value="R.1209")
@CheckName(value="R.1209")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.INTERFACE})
@CheckTitle(value="Do not use var for port declarations")
@CheckDescription(value="Do not use var for module or interface port declarations. It is preferred to use logic instead.\n\nExamples:\nmodule my_mod(\n\tinput logic port1,   // allowed\n\tinput var port2);    // not allowed\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1209
extends OVMComplianceCheck {
    public Check_R_1209(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(this.fOVMProject.getRfProject(), new PortDeclarationVisitor());
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class PortDeclarationVisitor
    implements IRfNamedElementVisitor {
        private PortDeclarationVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement element) {
            if (!(element instanceof RfPort)) {
                return true;
            }
            ParserPath parserPath = element.getFile().getParserPath();
            if (Check_R_1209.this.checkPrewaivers(parserPath)) {
                return true;
            }
            Check_R_1209.this.notifyCheckAlive();
            DataType portType = ((RfPort)element).getDataType();
            if (portType == null) {
                return true;
            }
            if (!"var".equals(portType.getNetType())) {
                return true;
            }
            Check_R_1209.this.addHit(element, "Illegal var used for declaration of port '" + LintUtils.getNamedElementFullName(element) + "'!");
            return true;
        }
    }
}

