/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="23.1.9")
@CheckID(value="R.1210")
@CheckName(value="R.1210")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.IMPORT, RuleLabel.DUPLICATE_CODE})
@CheckTitle(value="Duplicate Imports")
@CheckDescription(value="This check flags the use of duplicate imports inside modules, packages, interfaces and classes.\nExample:\n  import foo::a;\n  import foo::a;  // NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1210
extends OVMComplianceCheck {
    public Check_R_1210(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllModules()) {
            this.checkNamedElementAgainstDuplicates(rfNamedElement);
        }
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllInterfaces()) {
            this.checkNamedElementAgainstDuplicates(rfNamedElement);
        }
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllPackages()) {
            this.checkNamedElementAgainstDuplicates(rfNamedElement);
        }
        for (RfClass rfClass : this.fOVMProject.getAllClasses()) {
            this.checkNamedElementAgainstDuplicates(rfClass);
        }
    }

    private void addLocalHit(ImportInfo imp, ImportInfo matchingImp) {
        this.addHit(imp.getParserPath(), imp.getLine(), "Duplicate import with the one from line " + matchingImp.getLine() + " and file " + this.link(LintUtils.getFileShortName(matchingImp.getParserPath().path), matchingImp.getParserPath().path, matchingImp.getLine()) + "!", null);
    }

    private void checkImportForHit(ImportInfo imp, Map<String, ImportInfo> importForName) {
        if (imp instanceof ExplicitImportInfo) {
            String name = String.valueOf(imp.getPackageName()) + "::" + ((ExplicitImportInfo)imp).getElementName();
            if (importForName.containsKey(name)) {
                this.addLocalHit(imp, importForName.get(name));
            } else {
                importForName.put(name, imp);
                name = imp.getPackageName();
                if (importForName.containsKey(name)) {
                    this.addLocalHit(imp, importForName.get(name));
                }
            }
        } else {
            String name = imp.getPackageName();
            if (importForName.containsKey(name)) {
                this.addLocalHit(imp, importForName.get(name));
            } else {
                importForName.put(name, imp);
            }
        }
    }

    private void checkNamedElementAgainstDuplicates(RfNamedElement element) {
        if (this.checkPreWaivers(element.getFile())) {
            return;
        }
        this.notifyCheckAlive();
        NullProtectedList<ImportInfo> imports = element.getAllImportDeclarations();
        while (element.getEnclosingScope() != null) {
            element = element.getEnclosingScope();
            NullProtectedList<ImportInfo> enclosingLevelImports = element.getAllImportDeclarations();
            enclosingLevelImports.addAll(imports);
            imports = enclosingLevelImports;
        }
        HashMap<String, ImportInfo> importForName = new HashMap<String, ImportInfo>();
        for (ImportInfo imp : imports) {
            this.checkImportForHit(imp, importForName);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

