/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="23.1.11")
@CheckID(value="R.1211")
@CheckName(value="R.1211")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not allow multiple non-blocking assignments to the same bit")
@CheckDescription(value="You should not allow multiple non-blocking assignments to the same bit unless they are mutually exclusive.\nIf there are multiple non-blocking assignments to the same bit, only the last one will take effect.\n\nExamples:\n\t\tif (rst_ni) begin\n\t\t\tfoo_q <= 8'haa; // not allowed\n\t\tend\n\t\tif (!rst_ni) begin\n\t\t\tfoo_q <= 8'hab; //not allowed\n\t\tend\n\n\t\tif (rst_ni) begin\n\t\t\tfoo_en <= 8'haa; // allowed\n\t\tend else begin\n\t\t\tfoo_en <= 8'hab; // allowed\n\t\tend\n\nCheck supports pre-waiving.")
public class Check_R_1211
extends OVMComplianceCheck {
    private static final String ALWAYS = "always block";
    private static final String ALWAYS_LATCH = "always_latch block";
    private static final String ALWAYS_FF = "always_ff block";
    private static final String ALWAYS_COMB = "always_comb block";
    private static final String FINAL = "final block";
    private static final String INITIAL = "initial block";
    private static final String ERROR_MESSAGE_FORMAT = "Variable ''{0}'' is used in more than one non-blocking assignment in the following blocks:\n{1}";
    LinkedHashMap<CustomHid, LinkedHashSet<HidOccurrence>> elementToAssignmentsMap;
    Map<HidOccurrence, HidOperator> assignmentToOperatorMap;
    Map<HidOccurrence, LinkedHashSet<HidOccurrence>> assignmentToMutuallyExclusiveAssignmentsMap;
    Set<RfAbstractBlock> visitedCases;
    Map<RfAbstractBlock, Map<CustomHid, LinkedHashSet<HidOccurrence>>> assignmentsInIfMap;
    LinkedHashMap<RfField, LinkedHashMap<RfNamedElement, LinkedHashSet<HidOccurrence>>> hitInfo;

    public Check_R_1211(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.assignmentToMutuallyExclusiveAssignmentsMap = new HashMap<HidOccurrence, LinkedHashSet<HidOccurrence>>();
        this.elementToAssignmentsMap = new LinkedHashMap();
        this.hitInfo = new LinkedHashMap();
        this.assignmentToOperatorMap = new HashMap<HidOccurrence, HidOperator>();
        NullProtectedList<RfNamedElement> allComponents = new NullProtectedList<RfNamedElement>();
        allComponents.addAll(this.fOVMProject.getAllClasses());
        allComponents.addAll(this.fOVMProject.getAllPackages());
        allComponents.addAll(this.fOVMProject.getAllModules());
        allComponents.addAll(this.fOVMProject.getAllInterfaces());
        for (RfNamedElement component : allComponents) {
            this.hitInfo.clear();
            this.assignmentToOperatorMap.clear();
            List<RfNamedElement> members = component.getLocalMembers(RfNamedElement.class);
            if (members == null) continue;
            for (RfNamedElement rfNamedElement : members) {
                this.assignmentToMutuallyExclusiveAssignmentsMap.clear();
                this.elementToAssignmentsMap.clear();
                if (rfNamedElement instanceof RfField || allComponents.contains(rfNamedElement)) continue;
                this.checkMember(rfNamedElement);
            }
            for (Map.Entry entry : this.hitInfo.entrySet()) {
                LinkedHashMap locations;
                RfField field = (RfField)entry.getKey();
                if (field == null || (locations = (LinkedHashMap)entry.getValue()) == null) continue;
                this.addHit(field, this.getErrorMessage(field, locations));
            }
        }
    }

    private void checkMember(RfNamedElement currentMember) {
        HidOperatorVisitor nonBlockingAssignmentVisitor = new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (Check_R_1211.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1211.this.notifyCheckAlive();
                if (!hidOperator.isNBAssignment()) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                if (lhValue == null) {
                    return true;
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                RfHid hid = (RfHid)lhValue;
                IRfNamedElement hidElement = hid.getElement();
                if (hidElement == null) {
                    return true;
                }
                HidOccurrence hidOccurrence = hid.getOccurrence();
                if (hidOccurrence == null) {
                    return true;
                }
                CustomHid customHid = new CustomHid(hid);
                LinkedHashSet<Object> assignments = Check_R_1211.this.elementToAssignmentsMap.get(customHid);
                if (assignments == null) {
                    assignments = new LinkedHashSet();
                }
                assignments.add(hidOccurrence);
                Check_R_1211.this.elementToAssignmentsMap.put(customHid, assignments);
                Check_R_1211.this.assignmentToOperatorMap.put(hidOccurrence, hidOperator);
                Check_R_1211.this.assignmentToMutuallyExclusiveAssignmentsMap.put(hidOccurrence, new LinkedHashSet());
                return true;
            }
        };
        currentMember.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)nonBlockingAssignmentVisitor);
        this.assignmentsInIfMap = new HashMap<RfAbstractBlock, Map<CustomHid, LinkedHashSet<HidOccurrence>>>();
        this.visitedCases = new HashSet<RfAbstractBlock>();
        if (currentMember instanceof RfDuplicate) {
            return;
        }
        List<RfAbstractBlock> actionBlockList = currentMember.getLocalMembers(RfAbstractBlock.class);
        ArrayDeque<RfAbstractBlock> correspondingIfBlocks = new ArrayDeque<RfAbstractBlock>();
        while (actionBlockList != null && !actionBlockList.isEmpty()) {
            actionBlockList = this.checkActionBlocks(actionBlockList, correspondingIfBlocks);
        }
        for (Map.Entry<CustomHid, LinkedHashSet<HidOccurrence>> entry : this.elementToAssignmentsMap.entrySet()) {
            CustomHid customHid = entry.getKey();
            IRfNamedElement element = customHid.fElement;
            if (!(element instanceof RfField)) continue;
            RfField field = (RfField)element;
            LinkedHashSet<HidOccurrence> assignments = entry.getValue();
            LinkedHashSet<HidOccurrence> assignmentsCopy = new LinkedHashSet<HidOccurrence>();
            LinkedHashSet<HidOccurrence> shouldHit = new LinkedHashSet<HidOccurrence>();
            assignmentsCopy.addAll(assignments);
            for (HidOccurrence assignment : assignments) {
                assignmentsCopy.remove(assignment);
                if (shouldHit.contains(assignment)) continue;
                LinkedHashSet<HidOccurrence> currentMutuallyExclusiveAssignments = new LinkedHashSet<HidOccurrence>();
                LinkedHashSet<HidOccurrence> currentNonMutuallyExclusiveAssignments = new LinkedHashSet<HidOccurrence>();
                HashSet shouldNotCheck = new HashSet();
                for (HidOccurrence otherAssignment : assignmentsCopy) {
                    if (shouldHit.contains(otherAssignment)) continue;
                    if (shouldNotCheck.contains(otherAssignment)) {
                        if (!this.assignmentToMutuallyExclusiveAssignmentsMap.get(assignment).contains(otherAssignment)) {
                            currentNonMutuallyExclusiveAssignments.add(otherAssignment);
                            continue;
                        }
                        currentMutuallyExclusiveAssignments.add(otherAssignment);
                        continue;
                    }
                    if (!this.assignmentToMutuallyExclusiveAssignmentsMap.get(assignment).contains(otherAssignment)) {
                        shouldHit.add(assignment);
                        shouldHit.add(otherAssignment);
                        shouldNotCheck.addAll(this.assignmentToMutuallyExclusiveAssignmentsMap.get(otherAssignment));
                        currentNonMutuallyExclusiveAssignments.add(otherAssignment);
                        continue;
                    }
                    currentMutuallyExclusiveAssignments.add(otherAssignment);
                }
                for (HidOccurrence mutexAssignment : currentMutuallyExclusiveAssignments) {
                    this.assignmentToMutuallyExclusiveAssignmentsMap.get(mutexAssignment).addAll(currentNonMutuallyExclusiveAssignments);
                }
                for (HidOccurrence nonMutexAssignment : currentNonMutuallyExclusiveAssignments) {
                    this.assignmentToMutuallyExclusiveAssignmentsMap.get(nonMutexAssignment).addAll(currentMutuallyExclusiveAssignments);
                }
            }
            if (shouldHit.isEmpty()) continue;
            LinkedHashMap<RfNamedElement, LinkedHashSet<Object>> hitLocations = this.hitInfo.get(field);
            if (hitLocations == null) {
                hitLocations = new LinkedHashMap();
            }
            hitLocations.put(currentMember, shouldHit);
            this.hitInfo.put(field, hitLocations);
        }
    }

    private List<RfAbstractBlock> checkActionBlocks(List<RfAbstractBlock> actionBlockList, Deque<RfAbstractBlock> correspondingIfBlocks) {
        ArrayList<RfAbstractBlock> actionBlocksOnNextLevel = new ArrayList<RfAbstractBlock>();
        for (RfAbstractBlock actionBlock : actionBlockList) {
            RfFileDef file;
            if (actionBlock == null) continue;
            List<RfAbstractBlock> childrenActionBlocks = actionBlock.getLocalMembers(RfAbstractBlock.class);
            if (childrenActionBlocks != null && !childrenActionBlocks.isEmpty()) {
                actionBlocksOnNextLevel.addAll(childrenActionBlocks);
            }
            if ((file = actionBlock.getFile()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            if (actionBlock.isCase()) {
                if (this.visitedCases.contains(actionBlock)) continue;
                int cnt = 0;
                Collection<RfNamedElement> caseBranches = actionBlock.getMembers();
                if (caseBranches == null) continue;
                for (RfNamedElement branch : caseBranches) {
                    boolean isElsif;
                    RfAbstractBlock branchBlock;
                    ++cnt;
                    if (!(branch instanceof RfAbstractBlock) || this.visitedCases.contains(branchBlock = (RfAbstractBlock)branch)) continue;
                    this.visitedCases.add(branchBlock);
                    RfAbstractBlock correspondingIf = null;
                    RfAbstractBlock elseBlock = null;
                    boolean bl = isElsif = cnt > 1 && cnt < caseBranches.size();
                    if (cnt == caseBranches.size()) {
                        if (!correspondingIfBlocks.isEmpty()) {
                            correspondingIf = correspondingIfBlocks.pollLast();
                        }
                        elseBlock = branchBlock;
                    } else if (isElsif) {
                        if (!correspondingIfBlocks.isEmpty()) {
                            correspondingIf = correspondingIfBlocks.getLast();
                        }
                        elseBlock = branchBlock;
                    } else if (cnt == 1) {
                        correspondingIfBlocks.add(branchBlock);
                        correspondingIf = branchBlock;
                    }
                    if (correspondingIf == null) continue;
                    this.checkForNBAs(correspondingIf, elseBlock, isElsif);
                }
                continue;
            }
            this.visitedCases = new HashSet<RfAbstractBlock>();
            RfAbstractBlock correspondingIf = null;
            RfAbstractBlock elseBlock = null;
            boolean isElsif = actionBlock.isElsIf();
            if (actionBlock.isElse()) {
                if (!correspondingIfBlocks.isEmpty()) {
                    correspondingIf = correspondingIfBlocks.pollLast();
                }
                elseBlock = actionBlock;
            } else if (actionBlock.isElsIf()) {
                if (!correspondingIfBlocks.isEmpty()) {
                    correspondingIf = correspondingIfBlocks.getLast();
                }
                elseBlock = actionBlock;
            } else if (actionBlock.isIf()) {
                correspondingIfBlocks.add(actionBlock);
                correspondingIf = actionBlock;
            }
            if (correspondingIf == null) continue;
            this.checkForNBAs(correspondingIf, elseBlock, isElsif);
        }
        return actionBlocksOnNextLevel;
    }

    private void checkForNBAs(final RfAbstractBlock ifBlock, final RfAbstractBlock elseBlock, final boolean isElsif) {
        final LinkedHashMap elementToAssignmentsInElsifMap = new LinkedHashMap();
        HidOperatorVisitor NBAsVisitor = new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                LinkedHashSet<Object> assignmentsInIf;
                Map<CustomHid, LinkedHashSet<HidOccurrence>> elementToAssignmentsInIfMap = Check_R_1211.this.assignmentsInIfMap.get(ifBlock);
                if (!hidOperator.isNBAssignment()) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                if (lhValue == null) {
                    return true;
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                RfHid hid = (RfHid)lhValue;
                IRfNamedElement hidElement = hid.getElement();
                if (hidElement == null) {
                    return true;
                }
                HidOccurrence hidOccurrence = hid.getOccurrence();
                if (hidOccurrence == null) {
                    return true;
                }
                CustomHid customHid = new CustomHid(hid);
                if (elseBlock == null) {
                    assignmentsInIf = elementToAssignmentsInIfMap.get(customHid);
                    if (assignmentsInIf == null) {
                        assignmentsInIf = new LinkedHashSet();
                    }
                    assignmentsInIf.add(hidOccurrence);
                    elementToAssignmentsInIfMap.put(customHid, assignmentsInIf);
                    Check_R_1211.this.assignmentsInIfMap.put(ifBlock, elementToAssignmentsInIfMap);
                } else if (isElsif) {
                    LinkedHashSet<HidOccurrence> assignmentsInElsif = (LinkedHashSet<HidOccurrence>)elementToAssignmentsInElsifMap.get(customHid);
                    if (assignmentsInElsif == null) {
                        assignmentsInElsif = new LinkedHashSet<HidOccurrence>();
                    }
                    assignmentsInElsif.add(hidOccurrence);
                    elementToAssignmentsInElsifMap.put(customHid, assignmentsInElsif);
                }
                if (elseBlock != null && (assignmentsInIf = elementToAssignmentsInIfMap.get(customHid)) != null) {
                    LinkedHashSet<HidOccurrence> currentMutuallyExclusiveAssignments = new LinkedHashSet<HidOccurrence>();
                    for (HidOccurrence hidOccurrence2 : assignmentsInIf) {
                        LinkedHashSet<HidOccurrence> hidOccurrenceMutex = Check_R_1211.this.assignmentToMutuallyExclusiveAssignmentsMap.get(hidOccurrence);
                        LinkedHashSet<HidOccurrence> assignmentMutex = Check_R_1211.this.assignmentToMutuallyExclusiveAssignmentsMap.get(hidOccurrence2);
                        currentMutuallyExclusiveAssignments.add(hidOccurrence2);
                        hidOccurrenceMutex.add(hidOccurrence2);
                        assignmentMutex.add(hidOccurrence);
                        Check_R_1211.this.assignmentToMutuallyExclusiveAssignmentsMap.put(hidOccurrence, hidOccurrenceMutex);
                        Check_R_1211.this.assignmentToMutuallyExclusiveAssignmentsMap.put(hidOccurrence2, assignmentMutex);
                    }
                }
                return true;
            }
        };
        if (elseBlock == null) {
            this.assignmentsInIfMap.put(ifBlock, new HashMap());
            ifBlock.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)NBAsVisitor);
        } else {
            elseBlock.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)NBAsVisitor);
        }
        Map<Object, Object> assignmentsInIf = new HashMap();
        if (isElsif) {
            assignmentsInIf = this.assignmentsInIfMap.get(ifBlock);
            for (Map.Entry elementToAssignments : elementToAssignmentsInElsifMap.entrySet()) {
                LinkedHashSet assignments;
                CustomHid element = (CustomHid)elementToAssignments.getKey();
                if (element == null || (assignments = (LinkedHashSet)elementToAssignments.getValue()) == null) continue;
                LinkedHashSet currentElementAssignmentsInIf = (LinkedHashSet)assignmentsInIf.get(element);
                if (currentElementAssignmentsInIf == null) {
                    currentElementAssignmentsInIf = new LinkedHashSet();
                }
                currentElementAssignmentsInIf.addAll(assignments);
                assignmentsInIf.put(element, currentElementAssignmentsInIf);
                this.assignmentsInIfMap.put(ifBlock, assignmentsInIf);
            }
        }
    }

    private String getErrorMessage(RfField field, LinkedHashMap<RfNamedElement, LinkedHashSet<HidOccurrence>> locations) {
        String message;
        StringBuilder nonBlockingMessage = new StringBuilder();
        for (Map.Entry<RfNamedElement, LinkedHashSet<HidOccurrence>> location : locations.entrySet()) {
            ArrayList declarations;
            Set assignments;
            RfNamedElement block = location.getKey();
            if (block == null || (assignments = (Set)location.getValue()) == null || (declarations = new ArrayList(block.getDeclarations())).isEmpty()) continue;
            ParserPath parserPath = ((RfDefElement)declarations.get(declarations.size() - 1)).getParserPath();
            int blockLine = ((RfDefElement)declarations.get(declarations.size() - 1)).getStartLine();
            if (parserPath == null) continue;
            String kind = block.getKindName();
            if (block instanceof RfActionBlock) {
                RfActionBlock actionBlock = (RfActionBlock)block;
                if (actionBlock.isInitial()) {
                    kind = INITIAL;
                } else if (actionBlock.isFinal()) {
                    kind = FINAL;
                } else if (actionBlock.isAlwaysComb()) {
                    kind = ALWAYS_COMB;
                } else if (actionBlock.isAlwaysFf()) {
                    kind = ALWAYS_FF;
                } else if (actionBlock.isAlwaysLatch()) {
                    kind = ALWAYS_LATCH;
                } else if (actionBlock.isAlways()) {
                    kind = ALWAYS;
                }
            }
            nonBlockingMessage.append(kind).append(this.link(" at line " + blockLine + " of " + LintUtils.getFileShortName(parserPath.toString()), parserPath.toString(), blockLine)).append(":\n");
            for (HidOccurrence assignment : assignments) {
                HidOperator expression = this.assignmentToOperatorMap.get(assignment);
                if (expression == null) continue;
                nonBlockingMessage.append(" '").append(expression.toString()).append("'").append(this.link(" at line " + assignment.getLine() + " of " + LintUtils.getFileShortName(parserPath.toString()), parserPath.toString(), assignment.getLine())).append("\n");
            }
            nonBlockingMessage.append("\n");
        }
        if (nonBlockingMessage.length() > 0) {
            nonBlockingMessage.deleteCharAt(nonBlockingMessage.length() - 1);
        }
        if ((message = MessageFormat.format(ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(field), nonBlockingMessage.toString())).endsWith("\n")) {
            message = message.substring(0, message.length() - 1);
        }
        return message;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static class CustomHid {
        public IRfNamedElement fElement;
        public RfHid fHid;

        public CustomHid(RfHid hid) {
            this.fElement = hid.getElement();
            this.fHid = hid;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fElement == null ? 0 : this.fElement.hashCode());
            result = 31 * result + (this.fHid == null ? 0 : this.fHid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomHid other = (CustomHid)obj;
            if (this.fElement == null ? other.fElement != null : !this.fElement.equals(other.fElement)) {
                return false;
            }
            return !(this.fHid == null ? other.fHid != null : !this.fHid.equals((Object)other.fHid));
        }
    }
}

