/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractNoSpaceBeforeParanthesis;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="23.1.9")
@CheckID(value="R.1212")
@CheckName(value="R.1212")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.METHOD, RuleLabel.PARENTHESIS})
@CheckTitle(value="Do not place space between method call and open parenthesis")
@CheckDescription(value="When calling a method, do not place a space between the name of the method and the open parenthesis.\n\nExamples:\n\nfoo();  //allowed\nfoo ();  //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1212
extends AbstractNoSpaceBeforeParanthesis {
    public Check_R_1212(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected DVTPair<Integer, String> getCallInfo(IHidObject rfHidObject) {
        if (!(rfHidObject instanceof RfHid)) {
            return null;
        }
        RfHid rfHid = (RfHid)rfHidObject;
        IRfNamedElement element = rfHid.getElement();
        if (element == null || !(element instanceof RfFunction)) {
            return null;
        }
        if (rfHid.getReparseInfo() == null) {
            return new DVTPair((Object)rfHid.getOffset(), (Object)rfHid.getName());
        }
        return null;
    }

    @Override
    protected String getHitMessage(String name) {
        return "Do not place space between method call '" + name + "' and open parenthesis!";
    }
}

