/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractNoSpaceBeforeParanthesis;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="23.1.9")
@CheckID(value="R.1213")
@CheckName(value="R.1213")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.MACRO, RuleLabel.PARENTHESIS})
@CheckTitle(value="Do not place space between macro call and open parenthesis")
@CheckDescription(value="When an if block has a name label, the else keyword must not be on the same line as the end label.\n\nExamples:\n\n`exampleMacro(a, b)    //allowed\n`exampleMacro (a, b)    //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1213
extends AbstractNoSpaceBeforeParanthesis {
    public Check_R_1213(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        try {
            this.fOVMProject.getRfProject().accept(new AbstractNoSpaceBeforeParanthesis.LocalDefVisitor());
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected DVTPair<Integer, String> getCallInfo(IHidObject hidObject) {
        HidOccurrence occurence = null;
        IReparseInfo reparserInfo = null;
        if (hidObject instanceof Hid) {
            reparserInfo = ((Hid)hidObject).getReparseInfo();
            occurence = ((Hid)hidObject).getOccurrence();
        }
        if (hidObject instanceof HidOperator) {
            reparserInfo = ((HidOperator)hidObject).getReparseInfo();
            occurence = ((HidOperator)hidObject).getOccurrence();
        }
        if (occurence == null || reparserInfo == null || !(reparserInfo instanceof ReparseInfo)) {
            return null;
        }
        ReparseInfo.ReparseElement[] reparseStack = ((ReparseInfo)reparserInfo).getReparseStack();
        if (reparseStack == null || reparseStack.length == 0) {
            return null;
        }
        if (reparseStack[0] == null || reparseStack[0].getReparseMacroName() == null) {
            return null;
        }
        return new DVTPair((Object)occurence.getOffset(), (Object)("`" + reparseStack[0].getReparseMacroName()));
    }

    @Override
    protected String getHitMessage(String name) {
        return "Do not place space between macro call " + name + " and open parenthesis!";
    }
}

