/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="23.1.18")
@CheckID(value="R.1214")
@CheckName(value="R.1214")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.MACRO})
@CheckTitle(value="Multiline macro definition formatting")
@CheckDescription(value="Multiline macro definitions must be formatted as follows:.\n- each line must be indented with 4 spaces except for the line containing the define statement;\n- the line continuation characters '\\' must be vertically aligned.\n\nExamples:\n\n`define macro(a, b) \\\n    foo(a, b);      \\  // allowed\nfoo(a, b);          \\  // not allowed\n    foo(a, b);  \\      // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1214
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    public Check_R_1214(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
            List<LiteralToken> defLineTokens;
            VlogFileInstance fileInstance = macro.getFileInstance();
            if (fileInstance == null) continue;
            ParserPath parserPath = fileInstance.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            if (macro.getLine() == macro.getEndLine() || (defLineTokens = this.getWSParser().getTokensOnLine(parserPath, macro.getLine())).isEmpty()) continue;
            LiteralToken searchedToken = null;
            for (LiteralToken token : defLineTokens) {
                if (!token.isLastTokenOnLine()) continue;
                searchedToken = token;
                break;
            }
            if (searchedToken == null) continue;
            int continuationCharLineOffset = searchedToken.getOffsetLine() + searchedToken.getStringToken().length();
            int line = macro.getLine() + 1;
            while (line <= macro.getEndLine()) {
                List<LiteralToken> tokensOnLine = this.getWSParser().getTokensOnLine(parserPath, line);
                if (!tokensOnLine.isEmpty()) {
                    boolean lastLine = line == macro.getEndLine();
                    for (LiteralToken token : tokensOnLine) {
                        int tokenOffset;
                        if (token.isFirstTokenOnLine() && token.getNoSpacesBefore() != 4) {
                            this.addHit(parserPath, line, "Wrong indentation for multiline macro definition!", null);
                        }
                        if (lastLine) break;
                        if (!token.isLastTokenOnLine() || (tokenOffset = token.getOffsetLine() + token.getStringToken().length()) == continuationCharLineOffset) continue;
                        this.addHit(parserPath, line, "Wrong vertical allignment for '\\' character in multiline macro definition!", null);
                    }
                }
                ++line;
            }
        }
    }
}

