/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractBannedIdentifierCheck;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="23.1.11")
@CheckID(value="R.1215")
@CheckName(value="R.1215")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.CONDITIONAL_DIRECTIVE})
@CheckTitle(value="Do not use conditional compilation directives in string literals")
@CheckDescription(value="Do not use `ifdef, `ifndef, `else, `elsif, `endif in string literals.\nWithout proper code highlighting it can be difficult to understand what is conditionaly compiled and what is printed.\nThis rule also checks inactive code.\n\nExamples:\n\nstring testString = \"test `ifdef\"; //not allowed\n\n`ifdef AAA\n\t$display(\" `endif\n\"); // not allowed\n`endif\n\nCheck supports pre-waiving.")
public class Check_R_1215
extends AbstractBannedIdentifierCheck {
    private static final String ERROR_MESSAGE_FORMAT = "String literal {0} contains a conditional compilation directive!";
    private static final HashSet<Pattern> directivesPatternsInactive;
    private static final HashSet<Pattern> directivesPatternsLiteral;
    private static final HashSet<String> directivesNames;

    static {
        directivesNames = new HashSet();
        directivesNames.add("`ifdef");
        directivesNames.add("`ifndef");
        directivesNames.add("`else");
        directivesNames.add("`elsif");
        directivesNames.add("`endif");
        directivesPatternsInactive = new HashSet();
        directivesPatternsLiteral = new HashSet();
        for (String directive : directivesNames) {
            directivesPatternsInactive.add(Pattern.compile(directive));
            directivesPatternsLiteral.add(Pattern.compile(directive));
        }
    }

    public Check_R_1215(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkStringLiterals(directivesPatternsLiteral, false);
        this.checkInsideInactiveCode(directivesPatternsInactive, false, SVTBWhitespaceParser.ZoneType.STRING);
    }

    @Override
    protected void inactiveMatchAddHit(ParserPath path, int currentLine, String tokenString, Pattern pattern) {
        this.addHit(path, currentLine, MessageFormat.format(ERROR_MESSAGE_FORMAT, pattern), null);
    }

    @Override
    protected void stringLiteralMatchAddHit(ParserPath path, HidOperator operator, String expression, Pattern pattern) {
        this.addHit(path, (HidOccurrence)operator.getOccurrence(), MessageFormat.format(ERROR_MESSAGE_FORMAT, pattern), true);
    }
}

