/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="23.1.11")
@CheckID(value="R.1216")
@CheckName(value="R.1216")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.FIELD, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Use field macros on all fields from a class")
@CheckDescription(value="All classes that inherit from <baseClass> must have all their fields registered by field macros `xvm_field_*.\nAll fields of type class are ignored.\n\nExample when <baseClass> is class_parent:\n\nclass class_child extends class_parent;\n  int aa;\n  int bb;   // not allowed\n  `xvm_field_utils_begin(class_child)\n    `xvm_field_int(aa, XVM_ALL_ON);\n  `xvm_field_utils_end\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1216
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Check all classes that inherit from <baseClass> full name.", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pBaseClass;
    private HashSet<String> fRelevantMacros = new HashSet();
    private Set<RfClass> visitedClasses;

    public Check_R_1216(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.fRelevantMacros.addAll(Arrays.asList(XVMMacros.OVM_FIELD_MACROS));
        } else if (this.fOVMProject.getLibraryKind() == 2) {
            this.fRelevantMacros.addAll(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("class", this.fRelevantMacros);
    }

    @Override
    public void performCheckImpl() {
        this.visitedClasses = new HashSet<RfClass>();
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClass, true);
        if (baseClass == null) {
            this.addHit(null, "Class '" + this.pBaseClass + "' not found!");
            return;
        }
        this.visitedClasses.add(baseClass);
        Set<RfClass> children = baseClass.getChildren();
        if (children != null && !children.isEmpty()) {
            for (RfClass child : children) {
                this.checkChild(child);
            }
        }
    }

    private void checkChild(RfClass clazz) {
        if (clazz == null) {
            return;
        }
        if (this.visitedClasses.contains(clazz)) {
            return;
        }
        this.visitedClasses.add(clazz);
        Set<RfClass> children = clazz.getChildren();
        if (children != null && !children.isEmpty()) {
            for (RfClass child : children) {
                this.checkChild(child);
            }
        }
        if (this.fOVMProject.isOVMElement(clazz) || this.checkPreWaivers(clazz)) {
            return;
        }
        this.notifyCheckAlive();
        Set<MacroCallItem> macroCalls = this.getMacroCalls(clazz);
        List<RfField> fields = clazz.getFields();
        if (fields == null || fields.isEmpty()) {
            return;
        }
        for (RfField field : fields) {
            if (field.getAssociatedType() instanceof RfClass) continue;
            boolean found = false;
            block2: for (MacroCallItem macroCall : macroCalls) {
                String[] macroParameters;
                String[] stringArray = macroParameters = macroCall.getMacroParameters();
                int n = macroParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    String macroParameter = stringArray[n2];
                    if (field.getName().equals(macroParameter)) {
                        found = true;
                        continue block2;
                    }
                    ++n2;
                }
            }
            if (found) continue;
            this.addHit(field, "Field '" + LintUtils.getNamedElementFullName(field) + "' is not registered by any field macro calls!");
        }
    }

    private Set<MacroCallItem> getMacroCalls(RfClass clazz) {
        HashSet<MacroCallItem> macroCalls = new HashSet<MacroCallItem>();
        MacroCallInfo macroInfo = clazz.getMacroCallInfo();
        if (macroInfo == null) {
            return macroCalls;
        }
        List<MacroCallItem> macroCallsList = LintUtils.getMacroCallsInSet(macroInfo, this.fRelevantMacros, false, false);
        if (macroCallsList == null || macroCallsList.isEmpty()) {
            return macroCalls;
        }
        for (MacroCallItem macroCall : macroCallsList) {
            if (!this.fRelevantMacros.contains(macroCall.getName())) continue;
            macroCalls.add(macroCall);
        }
        return macroCalls;
    }

    public boolean checkPreWaivers(RfNamedElement elem) {
        if (elem.getFile() == null || elem.getFile().getParserPath() == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(elem.getFile().getParserPath(), this);
    }
}

