/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.12")
@CheckID(value="R.1217")
@CheckName(value="R.1217")
@CheckLabel(labels={RuleLabel.FACTORY_OVERRIDE, RuleLabel.METHOD, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not directly call type or instance override methods from the uvm_factory class")
@CheckDescription(value="This rule flags the usage of type and instance overrides using the methods of class xvm_factory such as:\n\nxvm_factory::get().set_inst_override_by_type(\"\", old_type_name::get_type(), new_type_name::get_type() ); // NOT ALLOWED\n\nWhen using a factory override to substitute a transaction, sequence, or component object with another object whose class extends the class of the original, to ensure a consistent code, the factory override should take one of these forms:\n\nold_type_name::type_id::set_type_override( new_type_name::get_type() ); // ALLOWED\nold_type_name::type_id::set_inst_override( new_type_name::get_type() ... ); // ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1217
extends OVMComplianceCheck {
    private final String globalFactoryName;
    private static final Set<String> XVM_FACTORY_METHODS = new HashSet<String>(Arrays.asList("set_inst_override_by_name", "set_inst_override_by_type", "set_type_override_by_name", "set_type_override_by_type"));

    public Check_R_1217(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.globalFactoryName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_factory");
    }

    @Override
    public void performCheckImpl() {
        final RfClass factoryClass = this.fOVMProject.getRfProject().getClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::" + this.globalFactoryName), true);
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                Check_R_1217.this.notifyCheckAlive();
                if (Check_R_1217.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                IRfNamedElement elem = hidObject.getElement();
                if (!(elem instanceof RfFunction)) {
                    return true;
                }
                if (!XVM_FACTORY_METHODS.contains(hidObject.getName())) {
                    return true;
                }
                RfClass enclosingClass = (RfClass)elem.getEnclosingScope(RfClass.class);
                if (enclosingClass == null) {
                    return true;
                }
                if (!LintUtils.isSubClassOf(enclosingClass, factoryClass)) {
                    return true;
                }
                Check_R_1217.this.addHit(this.parserPath, hidObject.getOccurrence(), "Method '" + LintUtils.getNamedElementFullName((RfNamedElement)elem) + "' is used to override!");
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

