/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.12")
@CheckID(value="R.1218")
@CheckName(value="R.1218")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.FORMAT_SPECIFIER, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Use %0 in format specifiers whenever applicable")
@CheckDescription(value="Do not use format specifiers for numbers without minimum width flag '%0' in format strings.\nPrinting without '%0' before the format letter will cause printing of unnecessary bits or spaces.\n\nExamples:\n\nint a;\n$display(\"%d\", a);  // not allowed\n$display(\"%0d\", a); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1218
extends OVMComplianceCheck {
    private static final Pattern REGEX_PATTERN = Pattern.compile("(^|[^%]*)%[bBdDhHoOeEfFgG]");
    private static final Pattern SPLIT_PATTERN = Pattern.compile("%%");

    public Check_R_1218(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (Check_R_1218.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1218.this.notifyCheckAlive();
                if (!hidObject.isMethodCall(false) || !LintUtilsConstants.PRINT_TASKS.contains(hidObject.getName())) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    block1: for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        if (!(entry.getValue() instanceof RfHidImplicit)) continue;
                        RfHidImplicit rfHidImplicit = (RfHidImplicit)entry.getValue();
                        String[] splitString = DVTStringUtil.split((Pattern)SPLIT_PATTERN, (String)rfHidImplicit.getName());
                        int i = 0;
                        while (i < splitString.length) {
                            Matcher stringMatcher = REGEX_PATTERN.matcher(splitString[i]);
                            if (stringMatcher.find()) {
                                boolean isForce = LintUtils.isInsideXVMReportingMacro(Check_R_1218.this.fOVMProject.getLibraryKind() == 2, hidObject.getOccurrence().getReparseInfo());
                                Check_R_1218.this.addHit(this.parserPath, hidObject.getOccurrence(), "String " + rfHidImplicit.getName() + " contains a format specifier without minimum width flag '%0'!", isForce);
                                continue block1;
                            }
                            ++i;
                        }
                    }
                }
                return true;
            }
        });
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

