/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="23.1.12")
@CheckID(value="R.1219")
@CheckName(value="R.1219")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.FIELD, RuleLabel.STYLING, RuleLabel.UVM_SEQUENCE, RuleLabel.COMPONENT, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Use the name m_config as the field name of the configuration object in the sequence or component in which it is declared")
@CheckDescription(value="You should use the name m_config as the instance name of the configuration object in the component or sequence in which it\u2019s been declared.\nIf there are multiple configuration object instances, you can use m_*_config as their field name.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="configurationObjectClassNamePattern", isVisible=true)
public class Check_R_1219
extends AbstractNamePatternParametersCheck {
    private static final String M_CONFIG = "m_config";
    private static final String PREFIX = "m_";
    private static final String SUFFIX = "_config";

    public Check_R_1219(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.getClassesWithPatterns("configurationObjectClassNamePattern").isEmpty() || this.fOVMProject.fOvmComponent == null || this.fOVMProject.fOvmSequence == null) {
            return;
        }
        Set<RfClass> allComponents = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmComponent);
        Set<RfClass> allSequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        for (RfClass component : allComponents) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(component.getFile())) continue;
            this.checkClass(component);
        }
        for (RfClass sequence : allSequences) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(sequence.getFile())) continue;
            this.checkClass(sequence);
        }
    }

    private void checkClass(RfClass clazz) {
        List<RfField> fields = clazz.getLocalFields();
        if (fields != null && !fields.isEmpty()) {
            for (RfField field : fields) {
                String fieldName;
                if (!this.isConfigObjectField(field) || (fieldName = field.getName()).equals(M_CONFIG) || fieldName.startsWith(PREFIX) && fieldName.endsWith(SUFFIX)) continue;
                this.addHit(field, "You should use the name m_config or m_*_config as the field name for the configuration object!");
            }
        }
    }

    boolean isConfigObjectField(RfField field) {
        RfNamedElement assocType = LintUtils.getAssociatedFinalType(field);
        return assocType != null && assocType instanceof RfClass && this.getClassesWithPatterns("configurationObjectClassNamePattern").containsKey(assocType.getFullName());
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

