/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="23.1.12")
@CheckID(value="R.1220")
@CheckName(value="R.1220")
@CheckLabel(labels={RuleLabel.DESIGN, RuleLabel._4_STATE, RuleLabel.ENUM})
@CheckTitle(value="Use 4-state types for synthesizable enum types")
@CheckDescription(value="This rule checks that all enums are defined with a 4-state type.\nThe 4-state types are: logic, integer, reg and time.\n\nExamples:\n\nenum integer { //allowed\n  IDLE,\n  RUNNING\n} enum1;\n\nenum int {     //not allowed\n  IDLE,\n  RUNNING\n} enum2;\n\nCheck supports pre-waiving.")
public class Check_R_1220
extends OVMComplianceCheck {
    public Check_R_1220(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IRfNamedElementVisitor visitor = namedElement -> {
            if (!(namedElement instanceof RfStruct)) {
                return true;
            }
            RfStruct rfStruct = (RfStruct)namedElement;
            if (!rfStruct.isEnum()) {
                return true;
            }
            this.notifyCheckAlive();
            if (this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            IRfNamedElement enumElementType = rfStruct.getEnumBaseType();
            if (LintUtils.isFourStateType(enumElementType, true)) {
                return true;
            }
            String enumName = rfStruct.getAliasName() != null ? "'" + rfStruct.getAliasName() + "' " : "";
            this.addHit(namedElement, "Enum " + enumName + "is not defined with a 4-state type!");
            return true;
        };
        this.fOVMProject.getRfProject().accept(visitor);
    }

    protected boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

