/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;

@CheckVersion(value="23.1.12")
@CheckID(value="R.1221")
@CheckName(value="R.1221")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.TASK, RuleLabel.MODULE, RuleLabel.INTERFACE, RuleLabel.PROGRAM, RuleLabel.DESIGN})
@CheckTitle(value="Do not declare tasks")
@CheckDescription(value="This check verifies that there are no tasks declared in design elements such as modules, interfaces, programs.\n\nmodule m;\n  task c() // NOT ALLOWED\n  endtask\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1221
extends OVMComplianceCheck {
    public Check_R_1221(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<Class> designElements = new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class, RfProgram.class));
        for (RfNamedElement task : this.fOVMProject.getAllTasks()) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(task.getFile().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            if (task.getEnclosingScope(designElements) == null) continue;
            this.addHit(task, "Task '" + LintUtils.getNamedElementFullName(task) + "' declared!");
        }
    }
}

