/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;

@CheckVersion(value="23.1.12")
@CheckID(value="R.1222")
@CheckName(value="R.1222")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.DESIGN})
@CheckTitle(value="Declare module port type as logic")
@CheckDescription(value="The preferred port type is 'logic' for all modules and it should be explicitly declared.\n\nExamples:\nmodule foo (\n    input var clk_i, //not allowed\n    input var integer d_i, //not allowed\n    output var logic q_o //allowed\n\t);\nendmodule\n\n\nCheck supports pre-waiving.")
public class Check_R_1222
extends OVMComplianceCheck {
    private static final String LOGIC = "logic";

    public Check_R_1222(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement currentModule : this.fOVMProject.getAllModules()) {
            if (!(currentModule instanceof RfModule) || this.checkPreWaivers(currentModule.getDeclaration())) continue;
            this.notifyCheckAlive();
            RfModule module = (RfModule)currentModule;
            List<IRfPortElement> ports = module.getLocalPorts();
            if (ports == null || ports.isEmpty()) continue;
            for (IRfPortElement currentPort : ports) {
                boolean isTypeDef;
                if (!(currentPort instanceof RfPort)) continue;
                RfPort port = (RfPort)currentPort;
                RfNamedElement assocType = LintUtils.getAssociatedFinalType(port);
                DataType dataType = port.getDataType();
                if (dataType != null && dataType.getType() != null && dataType.getType().equals(LOGIC)) continue;
                boolean bl = isTypeDef = dataType != null && dataType.getType() != null;
                if (isTypeDef && assocType != null && assocType.getName().equals(LOGIC)) continue;
                this.addHit(port.getNamedElement(), "Port '" + port.getName() + "' should be explicitly declared as logic!");
            }
        }
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }
}

