/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.13")
@CheckID(value="R.1223")
@CheckName(value="R.1223")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.NAME, RuleLabel.SUPER, RuleLabel.OVERRIDE})
@CheckTitle(value="Super call of the parent method implementation should match the current method name")
@CheckDescription(value="\nWhen overwriting a method, the super call should match the method name.\nThis is useful in case there is a typo in the method declaration or the super call.\n\nExample:\nfunction foo();\n\tsuper.boo() //not allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1223
extends OVMComplianceCheck {
    public Check_R_1223(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass[] allClasses;
        RfClass[] rfClassArray = allClasses = this.fOVMProject.getRfProject().getAllClasses();
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass checkedClass = rfClassArray[n2];
            this.performCheckOnMethods(checkedClass);
            ++n2;
        }
    }

    private void performCheckOnMethods(RfClass checkedClass) {
        ArrayList<RfFunction> allMethods = new ArrayList<RfFunction>();
        allMethods.addAll(checkedClass.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        allMethods.addAll(checkedClass.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        allMethods.addAll(checkedClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        IHidVisitor<IHidObject> visitor = new IHidVisitor<IHidObject>(){
            protected IHidHolder holder;
            protected ParserPath parserPath;
            private int boundary;

            public void setHolder(IHidHolder holder) {
                this.holder = holder;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(IHidObject hidObject) {
                if (!(this.holder instanceof RfHidHolder)) {
                    return false;
                }
                IRfNamedElement holderScope = ((RfHidHolder)this.holder).getScope();
                if (!(holderScope instanceof RfFunction)) {
                    return false;
                }
                RfFunction method = (RfFunction)holderScope;
                if (hidObject instanceof RfHidOperator) {
                    RfHidOperator hidOperator = (RfHidOperator)hidObject;
                    if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                        this.boundary = hidOperator.getCloseBoundary();
                    }
                    return true;
                }
                if (!(hidObject instanceof RfHid)) {
                    return true;
                }
                RfHid rfHid = (RfHid)hidObject;
                if (rfHid.getOffset() <= this.boundary) {
                    return true;
                }
                if (!"super".equals(rfHid.getName())) {
                    return false;
                }
                if (!rfHid.hasAccesses()) {
                    return false;
                }
                ListContainer hids = rfHid.getFirstAccess().getHids();
                if (hids == null || hids.size() != 1) {
                    return false;
                }
                Hid potentialMethodCall = (Hid)hids.iterator().next();
                if (!potentialMethodCall.getName().equals(method.getName())) {
                    Check_R_1223.this.addHit(this.parserPath, rfHid.getOccurrence(), "Super call:'" + HidUtils.toNiceString((IHidObject)potentialMethodCall) + "' should match the current method name:'" + method.getName() + "'!");
                    return false;
                }
                return false;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        };
        for (RfFunction method : allMethods) {
            this.notifyCheckAlive();
            if (method.isPredefined() || method.getDeclaration() == null) continue;
            ParserPath parserPath = method.getDeclaration().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            method.visitHidObject(null, visitor);
        }
    }
}

