/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.XSimEventScheduler;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalJumpStatementException;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvaluationGuardianCacheImpl;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalRangeException;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.interpreter.XVlog;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfParamsHolder;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="23.1.13")
@CheckID(value="R.1224")
@CheckName(value="R.1224")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.CONDITIONAL})
@CheckTitle(value="Do not use conditions that always evaluate to a 'true' or 'false' value")
@CheckDescription(value="Conditions that are always true or false cause unreachable code or infinite loops.\nSuch conditions can also cause confusion regarding how the execution unfolds which can lead to unexpected behavior when editing such code.\n\nExample: \n\nfunction flip_bits(bit[(WIDTH-1):0] vec);\n  bit skip = 0;\n  for (int i = 0; i < WIDTH; ++i) begin\n    if (skip) // 'skip' is always false\n      skip = !skip;\n    vec[i] = ~vec[i];\n  end\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1224
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Skip checking blocks inside macros that use macro arguments in their condition.", name="skipBlocksWithMacroArgsInConditions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipBlocksWithMacroArgsInConditions;
    private static final int BRANCH_KNOWN_KIND = 0;
    private static final int BRANCH_UNKNOWN_KIND = 1;
    private static final int LOOP_KNOWN_KIND = 1;
    private static final int LOOP_UNKNOWN_PRE_KIND = 2;
    private static final int LOOP_UNKNOWN_POST_KIND = 3;
    private static final int LOOP_KNOWN_ITERATION_MAX_COUNT = 1;
    private static final int LOOP_UNKNOWN_PRE_ITERATION_MAX_COUNT = 3;
    private static final Set<Class<? extends HidOperator>> LOOP_CLASSES = new ImmutableSet.Builder().add(HidEvalCenter.WhileLoopStatement.class).add(HidEvalCenter.DoWhileLoopStatement.class).add(HidEvalCenter.ForLoopStatement.class).add(HidEvalCenter.ForeachLoopStatement.class).add(HidEvalCenter.ForeverLoopStatement.class).add(HidEvalCenter.RepeatLoopStatement.class).build();
    private static final Set<Class<? extends HidOperator>> LOOP_AND_BRANCH_CLASSES = new ImmutableSet.Builder().add(HidEvalCenter.IfElseStatement.class).add(HidEvalCenter.CaseStatement.class).add(HidEvalCenter.CaseItemStatement.class).addAll(LOOP_CLASSES).build();

    private static boolean isDeclarationOperator(IHidObject hidObject) {
        return hidObject instanceof RfHidOperator.XInitialDeclarationOperator || hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).hasQualifier(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER | HidQualifierCache.IS_DECLARATION_EXPRESSION_QUALIFIER);
    }

    private static boolean isStaticUpdate(@NotNull IHidObject updateHidObject) {
        HidAccess parentAccess;
        IHidObject updateVariableHidObject = (IHidObject)updateHidObject.get(0);
        Hid updateVariableHid = null;
        if (updateVariableHidObject instanceof HidAccess) {
            updateVariableHid = ((HidAccess)updateVariableHidObject).getParentHid();
        } else if (updateVariableHidObject instanceof Hid) {
            updateVariableHid = (Hid)updateVariableHidObject;
        } else {
            return false;
        }
        do {
            if ((parentAccess = updateVariableHid.getParentAccess()) != null && parentAccess.getAccessKind() == 2) {
                return true;
            }
            IRfNamedElement element = updateVariableHid.getElement();
            if (element instanceof RfField && element.isStorageStatic()) {
                return true;
            }
            if (parentAccess != null) continue;
            return false;
        } while ((updateVariableHid = parentAccess.getParentHid()) != null);
        return false;
    }

    private static IELParamValue getOriginalWithoutSelectsValue(IELParamValue value) {
        if (value == null) {
            return null;
        }
        IELParamValue result = value;
        while ((result = result.getValueBeforeSelect()).getOriginal() != null) {
            result = result.getOriginal();
        }
        return result;
    }

    public Check_R_1224(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject project = this.fOVMProject.getRfProject();
        XVlogLinter sim = new XVlogLinter(project.getMixedLangProjectParent(), project.getELManager());
        XValueHolderFactory factory = sim.getFactory();
        XLinterHidEvaluationGuardian guardian = sim.getEvaluationGuardian(false);
        AssignmentOperatorsVisitor visitor = new AssignmentOperatorsVisitor(guardian);
        Consumer<RfNamedElement> checkScope = scope -> {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(scope.getDeclaration().getParserPath(), this)) {
                return;
            }
            this.notifyCheckAlive();
            scope.visitHidObject(project, visitor);
            IELParamValue evaluator = null;
            try {
                evaluator = factory.createValueHolder((IRfNamedElement)scope, null, null);
            }
            catch (XLinterEvaluationException xLinterEvaluationException) {
                return;
            }
            IELParamValue valueHolder = evaluator;
            while (valueHolder instanceof XValueHolder) {
                if (((XValueHolder)valueHolder).isStaticHolder()) break;
                ((XValueHolder)valueHolder).setIsUnknown(true);
                valueHolder = ((XValueHolder)valueHolder).getEnclosingValue();
            }
            IHidOperator convertedScope = HidEvalConverter.INSTANCE.convertElement((IRfNamedElement)scope, (IHidEvaluationGuardian)guardian, (IHidEvaluator)evaluator);
            try {
                ELUtils.evaluate((IHidObject)convertedScope, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)guardian);
            }
            catch (HidEvalJumpStatementException | XLinterEvaluationException object) {}
            guardian.reset();
        };
        project.accept(scope -> {
            if (scope instanceof RfParamsHolder && !scope.isPredefined()) {
                List<RfActionBlock> actionBlocks;
                List<RfFunction> functions = scope.getLocalMembers(RfFunction.class);
                if (functions != null && !functions.isEmpty()) {
                    for (RfFunction function : scope.getLocalMembers(RfFunction.class)) {
                        if (function.isPredefined()) continue;
                        checkScope.accept(function);
                    }
                }
                if (scope instanceof RfInstanceHolder && (actionBlocks = scope.getLocalMembers(RfActionBlock.class)) != null && !actionBlocks.isEmpty()) {
                    for (RfActionBlock actionBlock : actionBlocks) {
                        checkScope.accept(actionBlock);
                    }
                }
            }
            return true;
        });
        sim.terminate();
    }

    private final class AssignmentOperatorsVisitor
    implements IHidVisitor<RfHidOperator> {
        IRfNamedElement scope;
        XLinterHidEvaluationGuardian guardian;

        public AssignmentOperatorsVisitor(XLinterHidEvaluationGuardian guardian) {
            this.guardian = guardian;
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHidOperator operator) {
            if (operator.isAssignment() || operator.isArithmeticAssignment() || operator.isLogicalAssignment()) {
                this.guardian.addAssignmentOperatorScope(operator, this.scope);
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private static final class LoopInfo {
        public static final LoopInfo EMPTY = new LoopInfo();
        public int kind;
        public boolean startedWithUnknownKind;
        public boolean valuesChangedWhenHadUnkownKind;
        public Map<IELParamValue, IHidObject> readValuesCache;
        public Set<IELParamValue> writtenValuesCache;

        private LoopInfo() {
        }

        public LoopInfo(int kind) {
            this.kind = kind;
            this.startedWithUnknownKind = kind != 1;
            this.readValuesCache = new IdentityHashMap<IELParamValue, IHidObject>();
            this.writtenValuesCache = this.startedWithUnknownKind ? new IdentityHSet(4) : null;
        }
    }

    private static final class PotentialHitInfo {
        private boolean isTrue;
        private boolean isUnknown;
        public final IRfNamedElement scope;

        public PotentialHitInfo(IRfNamedElement scope, boolean isTrue, boolean isUnknown) {
            this.scope = scope;
            this.isTrue = isTrue;
            this.isUnknown = isUnknown;
        }

        private void update(boolean isTrue, boolean isUnknown) {
            this.isUnknown = this.isUnknown | isUnknown | this.isTrue ^ isTrue;
            this.isTrue = !this.isUnknown & (this.isTrue | isTrue);
        }

        public String getHitText() {
            IHidObject messageCondition;
            if (this.isUnknown || !(this.scope instanceof RfActionBlock)) {
                return null;
            }
            RfActionBlock blockScope = (RfActionBlock)this.scope;
            List<IHidObject> conditionParts = blockScope.computeConditionOperator(null, null);
            if (conditionParts == null) {
                return null;
            }
            IHidObject iHidObject = messageCondition = conditionParts.size() > 1 ? conditionParts.get(1) : conditionParts.get(0);
            if (blockScope.isCaseItem()) {
                return "Case alternative '" + HidUtils.toNiceString((IHidObject)messageCondition) + "' is always selected!";
            }
            if (blockScope.isCase()) {
                return "No case alternative is ever selected!";
            }
            if (blockScope.isForEach()) {
                IHidObject foreachArray = HidUtils.isHidAccess((IHidObject)messageCondition) ? ((HidAccess)messageCondition).getParentHid() : messageCondition;
                return "Foreach array '" + HidUtils.toNiceString((IHidObject)foreachArray) + "' is always empty!";
            }
            String messageBody = "'" + HidUtils.toNiceString((IHidObject)messageCondition) + "' always yields '" + this.isTrue + "'!";
            if (blockScope.isIf() || blockScope.isElsIf()) {
                return "If condition " + messageBody;
            }
            if (blockScope.isWhile() || blockScope.isDoWhile()) {
                return "While condition " + messageBody;
            }
            if (blockScope.isFor()) {
                return "For condition " + messageBody;
            }
            return null;
        }
    }

    private static final class XLinterEvaluationException
    extends XStopThreadException {
        private static final long serialVersionUID = 1L;

        private XLinterEvaluationException() {
        }
    }

    private final class XLinterHidEvaluationGuardian
    extends HidEvaluationGuardianCacheImpl {
        private XVlogLinter sim;
        private FlagsAndCounters flagsAndCounters;
        private Deque<Integer> branchKinds;
        private Deque<LoopInfo> loopInfos;
        private Map<IRfNamedElement, PotentialHitInfo> hitInfosUnderLoops;
        private Set<IELParamValue> staticValuesToReset;
        private Map<IHidOperator, IRfNamedElement> assignmentOperatorScopes;

        public XLinterHidEvaluationGuardian(XVlogLinter sim) {
            this.sim = sim;
            this.flagsAndCounters = new FlagsAndCounters();
            this.branchKinds = new ArrayDeque<Integer>(4);
            this.loopInfos = new ArrayDeque<LoopInfo>(4);
            this.hitInfosUnderLoops = new HashMap<IRfNamedElement, PotentialHitInfo>();
            this.staticValuesToReset = new IdentityHSet(16);
            this.assignmentOperatorScopes = new IdentityHashMap<IHidOperator, IRfNamedElement>();
        }

        public void incrementStepCount(int count) {
        }

        public void checkEvaluationStepLimit(IHidObject hidObject) {
        }

        public void resetStepCount() {
        }

        public void report(IllegalRangeException evalEx) {
        }

        public void report(UnknownEvaluationException ex) {
            if (this.flagsAndCounters.skippedException) {
                this.flagsAndCounters.skippedException = false;
                return;
            }
            if (ex instanceof SkippedHidObjectEvaluationException) {
                this.flagsAndCounters.skippedException = true;
                return;
            }
            this.flagsAndCounters.throwedException = true;
            throw new XLinterEvaluationException();
        }

        public void checkBuildCanceled() {
            if (this.sim.isTerminated()) {
                throw new BuildCancelException();
            }
        }

        public boolean shouldSkip(IHidObject hidObject) {
            if (hidObject instanceof HidOperator) {
                if (((HidOperator)hidObject).isVlogEventControl() || ((HidOperator)hidObject).isVlogEventTrigger() || ((HidOperator)hidObject).isForce()) {
                    return true;
                }
                int operatorType = ((RfHidOperator)hidObject).getOperatorType();
                if (operatorType == 194) {
                    return this.flagsAndCounters.branchUnknownKindCount + this.flagsAndCounters.loopUnknownKindCount != 0;
                }
                if (operatorType == 42 || operatorType == 59) {
                    return this.flagsAndCounters.branchUnknownKindCount != 0;
                }
            }
            return false;
        }

        public XValueHolderFactory getFactory() {
            return this.sim.getFactory();
        }

        public ELManager getManager() {
            return this.sim.getFactory().getManager();
        }

        public XThread getActiveThread() {
            return null;
        }

        public boolean isInterpreter() {
            return true;
        }

        public IXSim.XSimMode simulatorMode() {
            return IXSim.XSimMode.LINTER;
        }

        public boolean isLinterStaticAnalysisMode() {
            return true;
        }

        public boolean isVlogSystemCallExecuted(String name) {
            return true;
        }

        private void markHit(IRfNamedElement scope, IHidObject condition, boolean isTrue, boolean isUnknwon) {
            ReparseInfo.ReparseElement reparseElement;
            ReparseInfo reparseInfo;
            if (scope == null) {
                return;
            }
            if (Check_R_1224.this.pSkipBlocksWithMacroArgsInConditions && condition != null && scope instanceof RfActionBlock && (reparseInfo = ((RfActionBlock)scope).getDeclaration().getReparseInfo()) != null && (reparseElement = reparseInfo.getLastReparseElement()) != null) {
                ArrayList<String> macroParams = new ArrayList<String>();
                if (reparseElement.getReparseMacroParams() != null) {
                    String[] stringArray = reparseElement.getReparseMacroParams();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String param = stringArray[n2];
                        macroParams.add(param.trim());
                        ++n2;
                    }
                }
                if (!macroParams.isEmpty()) {
                    for (IHid hid : HidUtils.flattenToHids((IHidObject)condition, (Set)HidFlatteningOption.NONE_EXCLUDED)) {
                        if (!macroParams.contains(hid.getName())) continue;
                        return;
                    }
                }
            }
            if (this.loopInfos.isEmpty()) {
                String text = new PotentialHitInfo(scope, isTrue, isUnknwon).getHitText();
                if (text != null) {
                    Check_R_1224.this.addHit((RfNamedElement)scope, text);
                }
                return;
            }
            PotentialHitInfo hitInfo = this.hitInfosUnderLoops.get(scope);
            if (hitInfo == null) {
                hitInfo = new PotentialHitInfo(scope, isTrue, isUnknwon);
                this.hitInfosUnderLoops.put(scope, hitInfo);
                return;
            }
            hitInfo.update(isTrue, isUnknwon);
        }

        public void callbackStartStatement(XThread xThread, IHidObject statement) {
            if (statement != null && LOOP_CLASSES.contains(statement.getClass())) {
                this.loopInfos.push(LoopInfo.EMPTY);
            }
        }

        public void callbackEndStatement(XThread xThread, IHidObject statement) {
            if (this.flagsAndCounters.throwedException) {
                return;
            }
            if (statement == null) {
                return;
            }
            if (!LOOP_AND_BRANCH_CLASSES.contains(statement.getClass())) {
                return;
            }
            if (statement instanceof HidEvalCenter.IfElseStatement || statement instanceof HidEvalCenter.CaseStatement || statement instanceof HidEvalCenter.CaseItemStatement) {
                Integer branchKind = this.branchKinds.poll();
                this.flagsAndCounters.branchUnknownKindCount = this.flagsAndCounters.branchUnknownKindCount - (branchKind != null ? branchKind : 0);
                return;
            }
            LoopInfo loopInfo = this.loopInfos.poll();
            if (loopInfo == LoopInfo.EMPTY) {
                this.flagsAndCounters.throwedException = true;
                throw new XLinterEvaluationException();
            }
            if (loopInfo.startedWithUnknownKind && !loopInfo.writtenValuesCache.isEmpty()) {
                for (IELParamValue value : loopInfo.writtenValuesCache) {
                    ELUtils.setUnknownValue((IELParamValue)value);
                }
            }
            this.flagsAndCounters.loopUnknownKindCount = this.flagsAndCounters.loopUnknownKindCount - (loopInfo.kind > 1 ? 0 : 1);
            this.flagsAndCounters.loopUnknownPostKindCount = this.flagsAndCounters.loopUnknownPostKindCount - (loopInfo.kind == 3 ? 1 : 0);
            if (this.loopInfos.isEmpty()) {
                for (PotentialHitInfo hitInfo : this.hitInfosUnderLoops.values()) {
                    String text = hitInfo.getHitText();
                    if (text == null) continue;
                    Check_R_1224.this.addHit((RfNamedElement)hitInfo.scope, text);
                }
                this.hitInfosUnderLoops.clear();
                return;
            }
            this.loopInfos.peek().valuesChangedWhenHadUnkownKind |= loopInfo.valuesChangedWhenHadUnkownKind;
            this.loopInfos.peek().readValuesCache.putAll(loopInfo.readValuesCache);
        }

        public IELParamValue executeMethodCall(IHidObject hidObject, IRfMethodElement methodElement, IHidEvaluator methodEnclosingEvaluator, IHidEvaluator methodEvaluator, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
            IELParamValue newValue;
            if ("new".equals(methodElement.getName()) && methodEvaluator instanceof XValueHolder && (newValue = ((XValueHolder)methodEvaluator).getEnclosingValue()) instanceof XArrayValueHolder) {
                return ((XArrayValueHolder)newValue).executePredefinedMethod(null, methodEvaluator, argumentsEvaluator, specifiedArgumentValues);
            }
            boolean isSystemTaskOrFunction = XUtils.isSystemFunctionOrTask((IRfMethodElement)methodElement);
            for (HidEvalCenter.MethodCallStatement.ArgumentInfo valueScope : specifiedArgumentValues.values()) {
                RfField fieldValue;
                IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope.argValueScope);
                if (value == null || !isSystemTaskOrFunction && !valueScope.isRefOrOutput || isSystemTaskOrFunction && value.getElement() instanceof RfField && ((fieldValue = (RfField)value.getElement()).isEnumElement() || fieldValue.isConst() || fieldValue.isAnyParameter())) continue;
                IELParamValue originalValue = value.getOriginal();
                ELUtils.setUnknownValue((IELParamValue)(originalValue != null ? originalValue : value));
            }
            XValueHolder resultEvaluator = null;
            if (methodEvaluator instanceof XValueHolder) {
                IELParamValue valueToReset = ((XValueHolder)methodEvaluator).getEnclosingValue();
                if (valueToReset instanceof XValueHolder) {
                    XValueHolder valueHolderToReset = (XValueHolder)valueToReset;
                    XValueHolder xValueHolder = valueHolderToReset = valueHolderToReset.getRefValueHolder() != null ? valueHolderToReset.getRefValueHolder() : valueHolderToReset;
                    if (valueHolderToReset.isStaticHolder()) {
                        this.resetStaticValues();
                    } else if (valueHolderToReset instanceof XArrayValueHolder) {
                        ((XArrayValueHolder)valueHolderToReset).setHasUnknownSize(true);
                    } else {
                        valueHolderToReset.setIsUnknown(true);
                    }
                }
                ((XValueHolder)methodEvaluator).setIsUnknown(true);
                resultEvaluator = (XValueHolder)methodEvaluator;
            } else if (argumentsEvaluator instanceof XValueHolder) {
                resultEvaluator = (XValueHolder)argumentsEvaluator;
            } else {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (methodElement.isVoid()) {
                return IELParamValue.IMPLICIT_RESULT;
            }
            IELParamValue result = resultEvaluator.createValue((IRfNamedElement)methodElement);
            ELUtils.setUnknownValue((IELParamValue)result);
            return result;
        }

        public void guardValueAccess(IRfNamedElement element, IHidObject containingHidObject, IELParamValue value) {
            LoopInfo loopInfo;
            if (element instanceof RfField && containingHidObject instanceof IHid && (loopInfo = this.loopInfos.peek()) != null && loopInfo.kind > 1) {
                loopInfo.readValuesCache.put(Check_R_1224.getOriginalWithoutSelectsValue(value), containingHidObject);
            }
        }

        public void guardValueUpdate(IRfNamedElement element, IHidOperator containingOperator, IELParamValue leftValue, IELParamValue rightValue) {
            boolean isDefinedOutside;
            IELParamValue fullLeftValue = Check_R_1224.getOriginalWithoutSelectsValue(leftValue);
            if (!(element instanceof RfField)) {
                if (fullLeftValue == null) {
                    return;
                }
                element = fullLeftValue.getElement();
                if (!(element instanceof RfField)) {
                    return;
                }
            }
            if (rightValue == null) {
                if (leftValue != null) {
                    leftValue.updateValue(IELParamValue.UNDEFINED_VALUE, (IHidEvaluationGuardian)this);
                }
                return;
            }
            RfField field = (RfField)element;
            if (leftValue == null || Check_R_1224.isDeclarationOperator((IHidObject)containingOperator)) {
                if (!(field.isEnumElement() || field.isAnyParameter() && field.isEffectiveLocalParameter() || field.isForLoopParameter() || field.isVariable() && !field.isStorageStatic())) {
                    ELUtils.setUnknownValue((IELParamValue)rightValue);
                }
                if (leftValue != null) {
                    leftValue.updateValue(rightValue, (IHidEvaluationGuardian)this);
                }
                return;
            }
            if (this.flagsAndCounters.loopUnknownPostKindCount > 0) {
                ELUtils.setUnknownValue((IELParamValue)rightValue);
                leftValue.updateValue(rightValue, (IHidEvaluationGuardian)this);
                return;
            }
            LoopInfo loopInfo = this.loopInfos.peek();
            if (field.isForLoopParameter() && containingOperator == null) {
                if (loopInfo.kind > 1) {
                    ELUtils.setUnknownValue((IELParamValue)rightValue);
                    loopInfo.valuesChangedWhenHadUnkownKind = loopInfo.valuesChangedWhenHadUnkownKind | !leftValue.equals(rightValue);
                }
                leftValue.updateValue(rightValue, (IHidEvaluationGuardian)this);
                return;
            }
            boolean isStatic = containingOperator != null && Check_R_1224.isStaticUpdate((IHidObject)containingOperator) || field.isStorageStatic();
            boolean bl = isDefinedOutside = field.getEnclosingScope() != this.assignmentOperatorScopes.get(containingOperator);
            if (isDefinedOutside && this.flagsAndCounters.branchUnknownKindCount > 0) {
                if (loopInfo != null) {
                    loopInfo.valuesChangedWhenHadUnkownKind = loopInfo.valuesChangedWhenHadUnkownKind | loopInfo.kind > 1;
                }
                ELUtils.setUnknownValue((IELParamValue)rightValue);
                leftValue.updateValue(rightValue, (IHidEvaluationGuardian)this);
                return;
            }
            if (isDefinedOutside && loopInfo != null && loopInfo.startedWithUnknownKind) {
                loopInfo.writtenValuesCache.add(fullLeftValue);
            }
            if (this.flagsAndCounters.loopUnknownKindCount > 0 && loopInfo != null && loopInfo != LoopInfo.EMPTY) {
                loopInfo.valuesChangedWhenHadUnkownKind = loopInfo.valuesChangedWhenHadUnkownKind | loopInfo.kind > 1;
                if (containingOperator instanceof RfHidOperator) {
                    Set writtenValueHids;
                    boolean isOperationAssign;
                    RfHidOperator operator = (RfHidOperator)containingOperator;
                    boolean isIncrementOrDecrement = operator.isIncrementOrDecrement();
                    boolean bl2 = isOperationAssign = operator.isArithmeticAssignment() || operator.isLogicalAssignment();
                    if (isIncrementOrDecrement | isOperationAssign) {
                        ELUtils.setUnknownValue((IELParamValue)rightValue);
                        leftValue.updateValue(rightValue, (IHidEvaluationGuardian)this);
                        return;
                    }
                    IHidObject readValueHid = loopInfo.readValuesCache.get(fullLeftValue);
                    if (readValueHid != null && (writtenValueHids = HidUtils.flattenToUniqueHids((IHidObject)operator.getLHValue(), (Set)HidFlatteningOption.IMPLICITS_SELECTS_AND_ARGS_EXCLUDED)) != null && writtenValueHids.contains(readValueHid)) {
                        ELUtils.setUnknownValue((IELParamValue)rightValue);
                        leftValue.updateValue(rightValue, (IHidEvaluationGuardian)this);
                        return;
                    }
                }
            }
            if (isStatic) {
                this.staticValuesToReset.add(fullLeftValue);
            }
            leftValue.updateValue(rightValue, (IHidEvaluationGuardian)this);
        }

        public boolean guardControlFlowConditionTested(IRfNamedElement scope, IHidObject condition, IHidEvaluator evaluator, DVTNumber result, int loopCounter) {
            boolean isFalse;
            boolean isTrue = result == VlogBitVector.BIT_ONE;
            boolean isUnknown = this.flagsAndCounters.loopUnknownPostKindCount > 0 || result == VlogBitVector.BIT_UNKNOWN;
            boolean bl = isFalse = !(isTrue | isUnknown);
            if (loopCounter < 0) {
                int branchKind = isUnknown ? 1 : 0;
                this.flagsAndCounters.branchUnknownKindCount += branchKind;
                this.branchKinds.push(branchKind);
                this.markHit(scope, condition, isTrue, isUnknown);
                return isUnknown;
            }
            if (loopCounter == 0) {
                this.flagsAndCounters.loopUnknownKindCount = this.flagsAndCounters.loopUnknownKindCount + (isUnknown ? 1 : 0);
                this.loopInfos.poll();
                this.loopInfos.push(new LoopInfo(isUnknown ? (this.flagsAndCounters.loopUnknownPostKindCount > 0 ? 3 : 2) : 1));
                this.markHit(scope, condition, isTrue, isUnknown);
                return !isFalse;
            }
            LoopInfo loopInfo = this.loopInfos.peek();
            if (loopInfo.kind == 3) {
                return false;
            }
            if (loopCounter < 1 || isFalse) {
                this.flagsAndCounters.loopUnknownKindCount = this.flagsAndCounters.loopUnknownKindCount + (isUnknown ? 1 : 0);
                loopInfo.kind = isUnknown ? 2 : loopInfo.kind;
                this.markHit(scope, condition, isTrue, isUnknown);
                return !isFalse;
            }
            if ((--loopCounter != 0 || loopInfo.startedWithUnknownKind) && !loopInfo.valuesChangedWhenHadUnkownKind) {
                return false;
            }
            loopInfo.valuesChangedWhenHadUnkownKind = false;
            if (loopCounter == 3) {
                ++this.flagsAndCounters.loopUnknownPostKindCount;
                loopInfo.kind = 3;
                return true;
            }
            if (loopInfo.kind == 1) {
                ++this.flagsAndCounters.loopUnknownKindCount;
                loopInfo.kind = 2;
                this.markHit(scope, condition, isTrue, isUnknown || scope instanceof RfActionBlock && ((RfActionBlock)scope).isForEach());
                return true;
            }
            this.markHit(scope, condition, isTrue, isUnknown);
            return true;
        }

        protected void addAssignmentOperatorScope(IHidOperator operator, IRfNamedElement scope) {
            this.assignmentOperatorScopes.put(operator, scope);
        }

        protected void reset() {
            this.resetStaticValues();
            this.flagsAndCounters = new FlagsAndCounters();
            this.branchKinds.clear();
            this.loopInfos.clear();
            this.hitInfosUnderLoops.clear();
            this.assignmentOperatorScopes.clear();
        }

        private void resetStaticValues() {
            for (IELParamValue value : this.staticValuesToReset) {
                ELUtils.setUnknownValue((IELParamValue)value);
            }
            this.staticValuesToReset.clear();
        }

        private final class FlagsAndCounters {
            public int branchUnknownKindCount;
            public int loopUnknownKindCount;
            public int loopUnknownPostKindCount;
            public boolean throwedException;
            public boolean skippedException;

            private FlagsAndCounters() {
            }
        }
    }

    private final class XVlogLinter
    extends XVlog {
        public XVlogLinter(RfMixedLangProject mixedLangProject, ELManager manager) {
            super(mixedLangProject, manager, IXSim.XSimMode.LINTER, false, (IProgressMonitor)new NullProgressMonitor());
        }

        @Override
        protected XValueHolderFactory createXValueHolderFactory(RfMixedLangProject mixedLangProject, ELManager manager) {
            return new XValueHolderFactory(manager, (IXSim)this, true);
        }

        @Override
        protected IHidEvaluationGuardian createXHidEvaluationGuardian() {
            return new XLinterHidEvaluationGuardian(this);
        }

        public IXSim.XSimMode simulatorMode() {
            return IXSim.XSimMode.LINTER;
        }

        @Override
        protected boolean isTerminated() {
            return this.xThreadScheduler.isTerminated();
        }

        public IProject getProject() {
            return this.rfMixedLangProject.getProject();
        }

        public XLinterHidEvaluationGuardian getEvaluationGuardian(boolean createCopy) {
            return (XLinterHidEvaluationGuardian)(createCopy ? this.hidEvaluationGuardian.copy() : this.hidEvaluationGuardian);
        }

        @Override
        protected IXThreadScheduler createXThreadScheduler(IProgressMonitor monitor) {
            return new XSimEventScheduler((IXSim)this, monitor);
        }

        @Override
        protected IXThreadImpl createXThreadImpl(boolean disableStepIntoNewThread) {
            return null;
        }

        @Override
        protected void execute(XThreadDefinition xThreadDefinition) {
        }

        public void terminate() {
            this.xThreadScheduler.terminate(false, false);
            this.factory.terminate();
            XGlobalCache.INSTANCE.clearCache();
        }

        public ParserPath getCurrentParserPath() {
            return null;
        }

        public void setCurrentParserPath(ParserPath parserPath) {
        }

        public int getCurrentLineNumber() {
            return -1;
        }

        public void setCurrentLineNumber(int lineNumber) {
        }

        public void setCurrentLineNumber(IRfNamedElement namedElement) {
        }

        public void setInstanceScopeDebugContext(XInstValueHolder instanceScope) {
        }

        public void setDeferredReporting(IRfAssertExpectElement.AssertKind assertKind, XThread activeThread) {
        }

        public void resetDeferredReporting() {
        }

        public void printStackTrace(boolean isAsyncCall) {
        }

        public void printConcurrentAssertionsCursors() {
        }

        public void printSimTime() {
        }

        public void setPrintVerbosity(String verbosity) {
        }

        public String getPrintVerbosity() {
            return "UVM_MEDIUM";
        }

        public int getMaxLoopIterations() {
            return Integer.MAX_VALUE;
        }
    }
}

