/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.14")
@CheckID(value="R.1225")
@CheckName(value="R.1225")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.FUNCTIONAL, RuleLabel.SIGNAL, RuleLabel.CONDITIONAL, RuleLabel.COMPARISON})
@CheckTitle(value="Do not allow multi-bit signals in boolean contexts")
@CheckDescription(value="Instead of letting boolean operations and if expressions reduce a multi-bit signal to a single bit, explicitly compare the multi-bit signal to 0.\nThe implicit conversion can hide subtle logic bugs.\n\nExample:\nallowed: \nlogic [3:0] a, b;\nassign out = (a != '0) && (b == '0);\n\nnot allowed: \nlogic [3:0] a, b;\nassign out = a && b;\nwhile (a) ...\nfor (..., b, ...) ...\n\nCheck supports pre-waiving.")
public class Check_R_1225
extends OVMComplianceCheck {
    Set<String> bothSidesOperators = new HashSet<String>(Arrays.asList("&&", "||"));

    public Check_R_1225(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        LocalHidOperatorVisitor visitor = new LocalHidOperatorVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    private boolean isHidMultibit(RfHid hid, IRfNamedElement scope) {
        int i;
        if (hid.getElement() instanceof RfPredefinedFunction) {
            return false;
        }
        if (hid.getHidKind() != IHidObject.HidKind.HID && hid.getHidKind() != IHidObject.HidKind.ACCESS) {
            return false;
        }
        ELManager elManager = this.fOVMProject.getRfProject().getELManager();
        ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(elManager);
        RfHid hidNoAccess = hid.upwardsCopy(true);
        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)hidNoAccess.getElement(), null, (boolean)true, (ELManager)elManager);
        guardian.updateElements(hidNoAccess.getElement(), scope);
        ELParamValueScope paramValueForSize = ELUtils.evaluateForSize((IHidObject)hidNoAccess, (IHidEvaluator)evaluator, (IRfNamedElement)hidNoAccess.getElement(), (IHidEvaluationGuardian)guardian);
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)paramValueForSize)) {
            return false;
        }
        int unpackedDimensions = 0;
        DVTNumber numberForSize = paramValueForSize.getDVTNumber();
        while (!(numberForSize instanceof VlogBitVector)) {
            if (numberForSize instanceof DVTUnpackedArray) {
                numberForSize = ((DVTUnpackedArray)numberForSize).getElementType();
                ++unpackedDimensions;
                continue;
            }
            return false;
        }
        boolean atLeastOneDimensionBigger = false;
        VlogBitVector bitVector = (VlogBitVector)numberForSize;
        int[] packedDimensions = bitVector.getArrayDimensions();
        ListContainer accesses = hid.getAccesses();
        List selects = accesses == null ? null : ((HidAccess)accesses.get(0)).getSelects();
        int numAcceses = 0;
        if (selects != null) {
            i = unpackedDimensions;
            while (i < selects.size()) {
                IHidObject currentSelect = (IHidObject)selects.get(i);
                if (!(currentSelect == null || HidUtils.isOperator((IHidObject)currentSelect) && ((HidOperator)currentSelect).isRangeOrPartSelect())) {
                    ++numAcceses;
                }
                ++i;
            }
        }
        i = 2 * numAcceses;
        while (i < packedDimensions.length) {
            int smallDimension = packedDimensions[i];
            int bigDimension = packedDimensions[i + 1];
            if (smallDimension > bigDimension) {
                int aux = smallDimension;
                smallDimension = bigDimension;
                bigDimension = aux;
            }
            if (smallDimension < bigDimension) {
                atLeastOneDimensionBigger = true;
                break;
            }
            i += 2;
        }
        return atLeastOneDimensionBigger;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;
        private IRfNamedElement scope;

        private void addLocalHit(RfHid hid) {
            Check_R_1225.this.addHit(this.parserPath, hid, "Multibit signal '" + HidUtils.toNiceString((IHidObject)hid) + "' used in boolean context!");
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHidOperator hidOperator) {
            ArrayList<IHidObject> hidsWithError = new ArrayList<IHidObject>();
            if (hidOperator.getOperatorText() == null) {
                return true;
            }
            if (Check_R_1225.this.fOVMProject.isOVMFile(this.parserPath.path)) {
                return true;
            }
            if (Check_R_1225.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1225.this.notifyCheckAlive();
            if (Check_R_1225.this.bothSidesOperators.contains(hidOperator.getOperatorText())) {
                if (hidOperator.getLHValue().getHidKind() == IHidObject.HidKind.HID || hidOperator.getLHValue().getHidKind() == IHidObject.HidKind.ACCESS) {
                    hidsWithError.add(hidOperator.getLHValue());
                }
                if (hidOperator.getFirstRHValue() != null && (hidOperator.getFirstRHValue().getHidKind() == IHidObject.HidKind.HID || hidOperator.getFirstRHValue().getHidKind() == IHidObject.HidKind.ACCESS)) {
                    hidsWithError.add(hidOperator.getFirstRHValue());
                }
            } else if ("!".equals(hidOperator.getOperatorText())) {
                if (hidOperator.getLHValue().getHidKind() == IHidObject.HidKind.HID || hidOperator.getLHValue().getHidKind() == IHidObject.HidKind.ACCESS) {
                    hidsWithError.add(hidOperator.getLHValue());
                }
            } else if (("if".equals(hidOperator.getOperatorText()) || "while".equals(hidOperator.getOperatorText()) || "for".equals(hidOperator.getOperatorText())) && (hidOperator.getLHValue().getHidKind() == IHidObject.HidKind.HID || hidOperator.getLHValue().getHidKind() == IHidObject.HidKind.ACCESS)) {
                hidsWithError.add(hidOperator.getLHValue());
            }
            for (IHidObject hid : hidsWithError) {
                Hid parrentHid;
                RfHid rfHid = null;
                if (hid instanceof RfHid) {
                    rfHid = (RfHid)hid;
                } else if (hid instanceof RfHidAccess && (parrentHid = ((RfHidAccess)hid).getParentHid()) instanceof RfHid) {
                    rfHid = (RfHid)parrentHid;
                }
                if (rfHid == null || !Check_R_1225.this.isHidMultibit(rfHid, this.scope)) continue;
                this.addLocalHit(rfHid);
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

