/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.15")
@CheckID(value="R.1226")
@CheckName(value="R.1226")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not call methods with arguments variables of type time or realtime")
@CheckDescription(value="Calling methods with arguments of time and realtime types is not allowed because it may lead to unexpected behaviour. Time and realtime types do not retain any timeunit information.\n\nExample:\ntime t_var;\nrealtime rt_var;\nint i_var;\nfoo(t_var);      // not allowed\nfoo(rt_var);     // not allowed\nfoo(i_var);      // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1226
extends OVMComplianceCheck {
    public Check_R_1226(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new MethodCallVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class MethodCallVisitor
    extends RfHidVisitor {
        private MethodCallVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false) || hidObject.getElement() instanceof RfPropertySequence) {
                return true;
            }
            if (Check_R_1226.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1226.this.notifyCheckAlive();
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentRaw = (IHidObject)entry.getValue();
                    Set hidsFlatten = HidUtils.flattenToHids((IHidObject)argumentRaw, (Set)HidFlatteningOption.RANGE_CONSTANT_HIDS);
                    for (IHid hid : hidsFlatten) {
                        RfHid argumentHid;
                        IRfNamedElement argumentElement;
                        if (hid instanceof RfHidAccess) {
                            hid = ((RfHidAccess)argumentRaw).getParentHid();
                        }
                        if (!(hid instanceof RfHid) || !((argumentElement = (argumentHid = (RfHid)hid).getElement()) instanceof IRfAssociatedTypeElement)) continue;
                        RfNamedElement argumentType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)argumentElement);
                        boolean addHit = false;
                        if (argumentType instanceof RfBitVectorScalarType && "time".equals(argumentType.getName())) {
                            addHit = true;
                        }
                        if (argumentType instanceof RfPredefinedScalarType && "realtime".equals(argumentType.getName())) {
                            addHit = true;
                        }
                        if (!addHit) continue;
                        Check_R_1226.this.addHit(this.parserPath, hidObject, "Illegal " + argumentType.getName() + " argument used for '" + methodCall.method.getName() + "' method call: '" + HidUtils.toNiceString((IHidObject)argumentHid) + "'!");
                    }
                }
            }
            return true;
        }
    }
}

