/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;

@CheckVersion(value="23.1.16")
@CheckID(value="R.1227")
@CheckName(value="R.1227")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.PROPERTY, RuleLabel.ARGUMENT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not declare properties with arguments of type time and realtime")
@CheckDescription(value="Declaring properties with arguments of time and realtime types is not allowed because it may lead to unexpected behaviour. Time and realtime types do not retain any timeunit information.\n\nExample:\nproperty clk_enable_prop(time arg_t);      // not allowed\n  // property body\nendproperty\n\nproperty clk_enable_prop(int arg_i);      // allowed\n  // property body\nendproperty\n\nCheck supports pre-waiving.")
public class Check_R_1227
extends OVMComplianceCheck {
    public Check_R_1227(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement property : this.fOVMProject.getAllProperties()) {
            RfPropertySequence propertySeq;
            if (!(property instanceof RfPropertySequence) || this.checkPreWaivers((propertySeq = (RfPropertySequence)property).getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            List<RfField> arguments = propertySeq.getArgumentsWithPrefix("", 2);
            if (arguments == null || arguments.isEmpty()) continue;
            for (RfField argument : arguments) {
                RfNamedElement argumentType = LintUtils.getAssociatedFinalType(argument);
                boolean addHit = false;
                if (argumentType instanceof RfBitVectorScalarType && "time".equals(argumentType.getName())) {
                    addHit = true;
                }
                if (argumentType instanceof RfPredefinedScalarType && "realtime".equals(argumentType.getName())) {
                    addHit = true;
                }
                if (!addHit) continue;
                this.addHit(propertySeq, "Illegal " + argumentType.getName() + " used for '" + argument.getName() + "' argument of property '" + propertySeq.getName() + "'!");
            }
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

