/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="23.1.16")
@CheckID(value="R.1228")
@CheckName(value="R.1228")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not declare method argument types as time or realtime")
@CheckDescription(value="Method arguments are not allowed to be of types time and realtime.\n\nNot Allowed:\nfunction foo(time t, realtime r);\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1228
extends OVMComplianceCheck {
    public Check_R_1228(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allMethods = new NullProtectedList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement element : allMethods) {
            if (!(element instanceof RfFunction)) continue;
            RfFunction function = (RfFunction)element;
            this.notifyCheckAlive();
            RfDefElement declaration = function.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            for (IRfFieldElement argument : function.getArguments()) {
                String typeName;
                RfField arg;
                RfNamedElement assocType;
                if (!(argument instanceof RfField) || (assocType = LintUtils.getAssociatedFinalType(arg = (RfField)argument)) == null || arg.getDataType() == null || !"time".equals(typeName = assocType.getName()) && !"realtime".equals(typeName)) continue;
                this.addHit(arg, "Argument '" + LintUtils.getNamedElementFullName(arg) + "' is declared as '" + typeName + "' type!");
            }
        }
    }
}

