/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.16")
@CheckID(value="R.1229")
@CheckName(value="R.1229")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.INSTANTIATION, RuleLabel.PROPERTY, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not instantiate properties with variables of type time and realtime")
@CheckDescription(value="Instantiating properties with arguments of time and realtime types is not allowed because it may lead to unexpected behaviour. Time and realtime types do not retain any timeunit information.\n\nExample:\ntime t_var;\nrealtime rt_var;\nint i_var;\nassert property (clk_enable_P1(t_var));      // not allowed\nassert property (clk_enable_P1(rt_var));     // not allowed\nassert property (clk_enable_P1(i_var));      // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1229
extends OVMComplianceCheck {
    public Check_R_1229(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertion : this.fOVMProject.getAllAssertsExpects()) {
            List<? extends IHidObject> arguments;
            RfHidAccessArgs hidArgsExpression;
            void propertySpec;
            IHidObject expression;
            if (this.checkPreWaivers(assertion.getFile().getParserPath())) continue;
            RfAssertExpect tmpAssertion = (RfAssertExpect)assertion;
            this.notifyCheckAlive();
            IHidObject iHidObject = expression = tmpAssertion.getExpression();
            if (iHidObject instanceof RfHidOperator var5_5 && propertySpec.isPropertySpec()) {
                IHidObject iHidObject2 = expression = propertySpec.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR ? propertySpec.getLHValue() : propertySpec.getFirstRHValue();
            }
            if (!(expression instanceof RfHidAccessArgs) || !((hidArgsExpression = (RfHidAccessArgs)expression).getAssociatedType() instanceof RfPropertySequence) || (arguments = hidArgsExpression.getArgumentValues()) == null || arguments.isEmpty()) continue;
            for (IHidObject iHidObject3 : arguments) {
                Set hidsFlatten = HidUtils.flattenToHids((IHidObject)iHidObject3, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                for (IHid hid : hidsFlatten) {
                    RfHid argumentHid;
                    IRfNamedElement argumentElement;
                    if (hid instanceof RfHidAccess) {
                        hid = ((RfHidAccess)iHidObject3).getParentHid();
                    }
                    if (!(hid instanceof RfHid) || !((argumentElement = (argumentHid = (RfHid)hid).getElement()) instanceof IRfAssociatedTypeElement)) continue;
                    RfNamedElement argumentType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)argumentElement);
                    boolean addHit = false;
                    if (argumentType instanceof RfBitVectorScalarType && "time".equals(argumentType.getName())) {
                        addHit = true;
                    }
                    if (argumentType instanceof RfPredefinedScalarType && "realtime".equals(argumentType.getName())) {
                        addHit = true;
                    }
                    if (!addHit) continue;
                    this.addHit(assertion, "Illegal " + argumentType.getName() + " argument used for property instantiation: '" + HidUtils.toNiceString((IHidObject)argumentHid) + "'!");
                }
            }
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

