/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfStructDef;

@CheckVersion(value="23.1.16")
@CheckID(value="R.1230")
@CheckName(value="R.1230")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="File must always take the name of the single top entity")
@CheckDescription(value="Files must take the name of the defining entity\n\nA file that contains module \"clockgen\" must be named clockgen.sv\nA file that contains class \"packet\" must be named packet.sv\nA file named \"my_file\" that contains 2 classes \"my_cls1\" and \"my_cls2\" will flag both of them\n\nCheck supports pre-waiving.")
public class Check_R_1230
extends OVMComplianceCheck {
    Set<String> aAllowedExtensions = new HashSet<String>(Arrays.asList(".sv", ".svh"));

    public Check_R_1230(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath file : files) {
            Collection<RfDefElement> children;
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFile(file);
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file, this) || (children = fileDef.getChildren()) == null) continue;
            for (RfDefElement child : children) {
                if (child instanceof RfFunctionDef && child.getNamedElement() != null && ((RfFunctionDef)child).getNamedElement().isExtern() || child instanceof RfConstraintDef && child.getNamedElement() != null && ((RfConstraintDef)child).getNamedElement().isExtern() || child instanceof RfStructDef || child.getNamedElement() == null || this.checkFileName(fileDef.getName(), child.getNamedElement().toString())) continue;
                this.addHit(child.getParserPath(), child.getStartLine(), "Filename does not match the name of '" + child.getNamedElement().toString() + "'!", child.getReparseInfo());
            }
        }
    }

    private boolean checkFileName(String aFileName, String aEntityName) {
        if (aFileName == null || aEntityName == null) {
            return false;
        }
        boolean ok = false;
        for (String allowedExtension : this.aAllowedExtensions) {
            if (allowedExtension == null || !aFileName.equals(String.valueOf(aEntityName) + allowedExtension)) continue;
            ok = true;
            break;
        }
        return ok;
    }
}

