/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.20")
@CheckID(value="R.1231")
@CheckName(value="R.1231")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.TEST, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not set verbosity level in tests")
@CheckDescription(value="Do not call set_report_verbosity_level on tests and in tests. Verbosity should only be set through the command line argument.\n\nExample:\nclass my_test extends uvm_test;\n\tfunction foo();\n\t\tset_report_verbosity_level(UVM_HIGH); // not allowed\n\tendfunction\nendclass\n\nclass a;\n\tmy_test test;\n\tfunction foo();\n\t\ttest.set_report_verbosity_level(UVM_HIGH); // not allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1231
extends OVMComplianceCheck {
    private String fullMethodName;
    private Set<RfClass> baseClasses;
    @CheckParameter(defaultValue="xvm_pkg::xvm_test", description="Comma separated list of base classes for which the extending classes should not set the report verbosity level.", name="baseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pBaseClasses;

    public Check_R_1231(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.fullMethodName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_report_object") + ".set_report_verbosity_level";
        this.baseClasses = new HashSet<RfClass>();
        for (String baseClass : this.pBaseClasses) {
            this.baseClasses.add(this.fOVMProject.getRfProject().getClass(baseClass, true));
        }
        LocalRfHidVisitor hidVisitor = new LocalRfHidVisitor();
        rfProject.visitHidObject(rfProject, hidVisitor);
    }

    public void checkMethodCall(ParserPath aParserPath, RfHid aHid, RfClass clazz, RfField field) {
        for (RfClass baseClass : this.baseClasses) {
            if (!LintUtils.isSubClassOf(clazz, baseClass)) continue;
            this.addHit(aParserPath, aHid, "Report verbosity level has been set " + (field == null ? "in '" : "on field '" + LintUtils.getNamedElementFullName(field) + "' of type '") + LintUtils.getNamedElementFullName(clazz) + (field == null ? "' class" : "'") + "!");
        }
    }

    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalRfHidVisitor
    extends RfHidVisitor {
        RfNamedElement scope;

        private LocalRfHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (!hid.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1231.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1231.this.notifyCheckAlive();
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction calledFunction = (RfFunction)hidNamedElement;
            String calledFunctionFullName = LintUtils.getNamedElementFullName(calledFunction);
            if (!Check_R_1231.this.fullMethodName.equals(calledFunctionFullName)) {
                return true;
            }
            if (hid.getParentHid() == null) {
                RfClass clazz = this.scope.getEnclosingScope(RfClass.class);
                if (clazz == null) {
                    return true;
                }
                Check_R_1231.this.checkMethodCall(this.parserPath, hid, clazz, null);
            } else {
                Hid parentHid = hid.getParentHid();
                if (!(parentHid.getElement() instanceof RfNamedElement)) {
                    return true;
                }
                RfNamedElement parentNamedElement = (RfNamedElement)parentHid.getElement();
                if (!(parentNamedElement instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)parentNamedElement;
                RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (clazz == null) {
                    return true;
                }
                Check_R_1231.this.checkMethodCall(this.parserPath, hid, clazz, field);
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

