/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.19")
@CheckID(value="R.1232")
@CheckName(value="R.1232")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.LITERAL_VALUE, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not assign time literals to variables")
@CheckDescription(value="Assigning a time literal to a variable is not allowed because it may lead to unexpected behaviour. Calling a method with a time literal as a method argument value is flagged as well.\n\nExample:\nint t = 100ns; // not allowed\nfoo(100ns); // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1232
extends OVMComplianceCheck {
    public Check_R_1232(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisior());
        this.fOVMProject.getRfProject().visitHidObject(null, new MethodCallVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class MethodCallVisitor
    extends RfHidVisitor {
        private MethodCallVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (!(hid.getElement() instanceof RfFunction)) {
                return true;
            }
            if (Check_R_1232.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1232.this.notifyCheckAlive();
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentRaw = (IHidObject)entry.getValue();
                    Set hidsFlatten = HidUtils.flattenToHids((IHidObject)argumentRaw, EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
                    for (IHid argumentHid : hidsFlatten) {
                        if (!(argumentHid instanceof RfHidImplicit) || !LintUtils.isTimeValue(argumentHid.getName())) continue;
                        Check_R_1232.this.addHit(this.parserPath, hid.getOccurrence(), "Time literal '" + argumentHid.getName() + "' was assigned to argument '" + ((IRfFieldElement)entry.getKey()).getName() + "' of method '" + methodCall.getMethodName() + "'!");
                    }
                }
            }
            return true;
        }
    }

    private class OperatorVisior
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        private OperatorVisior() {
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isAssignment()) {
                return true;
            }
            if (Check_R_1232.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1232.this.notifyCheckAlive();
            IHidObject lhValue = hidObject.getLHValue();
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof RfHidImplicit)) {
                return true;
            }
            if (LintUtils.isTimeValue(((RfHidImplicit)rhValue).getName())) {
                Check_R_1232.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Time literal '" + ((RfHidImplicit)rhValue).getName() + "' was assigned to variable '" + (lhValue instanceof RfHid ? ((RfHid)lhValue).getName() : ((RfHidImplicit)lhValue).getName()) + "'!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

