/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.19")
@CheckID(value="R.1233")
@CheckName(value="R.1233")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.PROPERTY, RuleLabel.ARGUMENT, RuleLabel.LITERAL_VALUE, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use time literals as methods or properties arguments")
@CheckDescription(value="Calling a method or a property with a time literal as an argument value is not allowed because it may lead to unexpected behaviour.\n\nExample:\nfoo(100ns);                           // not allowed\nproperty clk_enable_prop(100ns);      // not allowed\n  // property body\nendproperty\n\nfoo(100);                             // allowed\nproperty clk_enable_prop(100);        // allowed\n  // property body\nendproperty\n\nCheck supports pre-waiving.")
public class Check_R_1233
extends OVMComplianceCheck {
    public Check_R_1233(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new MethodCallVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class MethodCallVisitor
    extends RfHidVisitor {
        private MethodCallVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (!hid.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1233.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1233.this.notifyCheckAlive();
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentRaw = (IHidObject)entry.getValue();
                    Set hidsFlatten = HidUtils.flattenToHids((IHidObject)argumentRaw, EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
                    for (IHid hidImplicit : hidsFlatten) {
                        if (!(hidImplicit instanceof RfHidImplicit) || !LintUtils.isTimeValue(hidImplicit.getName())) continue;
                        Check_R_1233.this.addHit(this.parserPath, methodCall.getOccurrence(), "Time literal '" + hidImplicit.getName() + "'  was assigned to argument '" + ((IRfFieldElement)entry.getKey()).getName() + "' of " + (hid.getElement() instanceof RfPropertySequence ? "property '" : "method '") + methodCall.getMethodName() + "'!");
                    }
                }
            }
            return true;
        }
    }
}

