/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractLiteralCheck;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="23.1.20")
@CheckID(value="R.1234")
@CheckName(value="R.1234")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE})
@CheckTitle(value="Do not use big numerical literals")
@CheckDescription(value="It's recommended that big numbers are defined as constants, macros or parameters. That way, the code is cleaner and it's easier to understand and maintain.\n\nExample:\nfor (i = 0; i < 10000; i++);          // not allowed\n\n`define BIG_NUMBER 10000\nfor (i = 0; i < `BIG_NUMBER; i++);    // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1234
extends AbstractLiteralCheck {
    @CheckParameter(defaultValue="1000", description="Highest allowed value that doesn't require a separate declaration.", name="allowedMaximumValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pAllowedMaximumValue;
    @CheckParameter(defaultValue="", description="Comma separated list of full method names that can be called with literal values higher than <allowedMaximumValue>.", name="allowedMethodCallArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedMethodCallArguments;
    private Map<ParserPath, Set<HidOccurrence>> allowedMethodCallOperators = new HashMap<ParserPath, Set<HidOccurrence>>();
    private Map<ParserPath, Map<Integer, Set<MacroCall>>> macroCalls = new HashMap<ParserPath, Map<Integer, Set<MacroCall>>>();

    public Check_R_1234(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (!this.pAllowedMethodCallArguments.isEmpty()) {
            this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator operator) {
                    if (!operator.hasQualifier(HidOperatorQualifier.IS_ARGUMENT_VALUE.value())) {
                        return true;
                    }
                    Set<HidOccurrence> parserPathOccurences = Check_R_1234.this.allowedMethodCallOperators.get(this.parserPath);
                    if (parserPathOccurences == null) {
                        parserPathOccurences = new HashSet<HidOccurrence>();
                        Check_R_1234.this.allowedMethodCallOperators.put(this.parserPath, parserPathOccurences);
                    }
                    parserPathOccurences.add((HidOccurrence)operator.getOccurrence());
                    Set flattenedOperators = HidUtils.flattenToOperators((IHidOperator)operator);
                    if (flattenedOperators == null || flattenedOperators.isEmpty()) {
                        return true;
                    }
                    for (IHidOperator flattenedOperator : flattenedOperators) {
                        Check_R_1234.this.allowedMethodCallOperators.get(this.parserPath).add((HidOccurrence)flattenedOperator.getOccurrence());
                    }
                    return true;
                }
            });
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new MacroDefVisitor());
        super.performCheckImpl();
        this.allowedMethodCallOperators.clear();
        this.macroCalls.clear();
    }

    @Override
    protected void analyzeImplicit(RfHidImplicit hidImplicit, ParserPath parserPath, int line, int offset) {
        Number number;
        if (!hidImplicit.isNumber()) {
            return;
        }
        this.notifyCheckAlive();
        IReparseElement lastReparseElement = hidImplicit.getLastReparseElement();
        if (lastReparseElement != null) {
            if (!(lastReparseElement instanceof ReparseInfo.ReparseElement)) {
                return;
            }
            ReparseInfo.ReparseElement reparseElement = (ReparseInfo.ReparseElement)lastReparseElement;
            if (reparseElement.getReparseMacroParams().length == 0) {
                return;
            }
            if (this.checkMacroParams(reparseElement, hidImplicit)) {
                return;
            }
        }
        Map<Integer, Set<MacroCall>> macroCallsInFile = this.macroCalls.get(parserPath);
        Set<MacroCall> macroCallsByLine = null;
        if (macroCallsInFile != null) {
            macroCallsByLine = macroCallsInFile.get(line);
        }
        if (macroCallsByLine != null) {
            for (MacroCall call : macroCallsByLine) {
                if (call.getLine() != line || call.getOffset() != offset) continue;
                ReparseInfo.ReparseElement reparseElement = call.getReparseElement();
                if (reparseElement.getReparseMacroParams().length == 0) {
                    return;
                }
                if (!this.checkMacroParams(reparseElement, hidImplicit)) continue;
                return;
            }
        }
        if ((number = hidImplicit.parseNumberValue()) == null) {
            return;
        }
        float value = number.floatValue();
        if (value == Float.MAX_VALUE) {
            try {
                value = Float.parseFloat(hidImplicit.getName());
            }
            catch (NumberFormatException numberFormatException) {
                value = 0.0f;
            }
        }
        if (value <= (float)this.pAllowedMaximumValue) {
            return;
        }
        String valueString = String.format("%s", Float.valueOf(value));
        if (value == (float)((long)value)) {
            valueString = String.format("%d", (long)value);
        }
        this.addHit(parserPath, line, "Illegal usage of big numerical literal: '" + valueString + "'!", null);
    }

    private boolean checkMacroParams(ReparseInfo.ReparseElement reparseElement, RfHidImplicit hidImplicit) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        String[] params = reparseElement.getReparseMacroParams();
        String[] unprocessedParams = reparseElement.getReparseMacroUnprocessedParams();
        int idx = 0;
        while (idx < params.length) {
            if (params[idx].contains(hidImplicit.getName())) {
                indexes.add(idx);
            }
            ++idx;
        }
        for (Integer index : indexes) {
            if (!params[index].equals(unprocessedParams[index])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean skipOperator(RfHidOperator hidOperator, ParserPath parserPath) {
        return !this.pAllowedMethodCallArguments.isEmpty() && this.allowedMethodCallOperators.get(parserPath) != null && this.allowedMethodCallOperators.get(parserPath).contains(hidOperator.getOccurrence());
    }

    @Override
    protected boolean skipFunction(String functionFullName) {
        return this.pAllowedMethodCallArguments.contains(functionFullName);
    }

    @Override
    protected boolean checkParameterAndConst() {
        return true;
    }

    @Override
    public void clean() {
        super.clean();
        if (this.allowedMethodCallOperators != null) {
            this.allowedMethodCallOperators.clear();
        }
        if (this.macroCalls != null) {
            this.macroCalls.clear();
        }
    }

    private static class MacroCall {
        private ReparseInfo.ReparseElement reparseElement;
        private int line;
        private int offset;

        public MacroCall(ReparseInfo.ReparseElement macro, int line, int offset) {
            this.reparseElement = macro;
            this.line = line;
            this.offset = offset;
        }

        public ReparseInfo.ReparseElement getReparseElement() {
            return this.reparseElement;
        }

        public int getLine() {
            return this.line;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MacroCall)) {
                return false;
            }
            MacroCall otherMacro = (MacroCall)obj;
            return this.reparseElement.equals(otherMacro.reparseElement) && this.line == otherMacro.line && this.offset == otherMacro.offset;
        }

        public int hashCode() {
            return Objects.hash(this.reparseElement, this.line, this.offset);
        }
    }

    private class MacroDefVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;

        private MacroDefVisitor() {
        }

        public boolean visit(IHidObject hidObject) {
            if (Check_R_1234.super.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1234.this.notifyCheckAlive();
            if (hidObject instanceof Hid) {
                IReparseInfo reparseInfo = ((Hid)hidObject).getReparseInfo();
                HidOccurrence occurence = ((Hid)hidObject).getOccurrence();
                if (reparseInfo == null) {
                    return true;
                }
                ReparseInfo.ReparseElement reparseElement = this.wrappedMacro(reparseInfo);
                if (reparseElement == null) {
                    return true;
                }
                Check_R_1234.this.macroCalls.putIfAbsent(this.parserPath, new HashMap());
                Check_R_1234.this.macroCalls.get(this.parserPath).putIfAbsent(occurence.getLine(), new HashSet());
                Check_R_1234.this.macroCalls.get(this.parserPath).get(occurence.getLine()).add(new MacroCall(reparseElement, occurence.getLine(), occurence.getOffset()));
                return true;
            }
            if (hidObject instanceof HidOperator) {
                IReparseInfo reparseInfo = ((HidOperator)hidObject).getReparseInfo();
                HidOperatorOccurrence occurence = ((HidOperator)hidObject).getOccurrence();
                if (reparseInfo == null) {
                    return true;
                }
                ReparseInfo.ReparseElement reparseElement = this.wrappedMacro(reparseInfo);
                if (reparseElement == null) {
                    return true;
                }
                Check_R_1234.this.macroCalls.putIfAbsent(this.parserPath, new HashMap());
                Check_R_1234.this.macroCalls.get(this.parserPath).putIfAbsent(occurence.getLine(), new HashSet());
                Check_R_1234.this.macroCalls.get(this.parserPath).get(occurence.getLine()).add(new MacroCall(reparseElement, occurence.getLine(), occurence.getOffset()));
                return true;
            }
            return true;
        }

        private ReparseInfo.ReparseElement wrappedMacro(IReparseInfo reparserInfo) {
            if (reparserInfo instanceof ReparseInfo) {
                ReparseInfo.ReparseElement[] reparseStack = ((ReparseInfo)reparserInfo).getReparseStack();
                if (reparseStack.length == 0) {
                    return ((ReparseInfo)reparserInfo).getLastReparseElement();
                }
                return reparseStack[0];
            }
            return null;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

