/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.20")
@CheckID(value="R.1235")
@CheckName(value="R.1235")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.EVENT_CONTROL, RuleLabel.PERFORMANCE})
@CheckTitle(value="Do not use event controls on signals without a timeout")
@CheckDescription(value="Using event controls on signals without a timeout will cause the simulation to run forever if the signals never change.\nThis check flags @ event controls in classes outside of any fork-join blocks.\nIf such an @ event control contains only signals defined in modules or interfaces, then it will be flagged.\n\nExamples:\n@(module.signal)  // not allowed\n@(module.signal or local_variable) // allowed\nwait(module.signal || timeout_value === 1) // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1235
extends OVMComplianceCheck {
    private Set<?> enclosingScopes = new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class, RfClass.class));
    @CheckParameter(defaultValue=".*clk.*, .*clock.*, .*rst.*, .*reset.*", description="Comma separated list of clock signals patterns to be skipped.", name="skipSignalPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pSkipSignalPatterns;
    @CheckParameter(defaultValue="false", description="When true, only sequences will be checked.", name="checkOnlySequences", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlySequences;

    public Check_R_1235(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            clazz.visitHidObject(null, new LocalHidVisitor(clazz));
        }
    }

    class LocalHidVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private RfNamedElement scope;
        private RfClass enclosingClass;

        public LocalHidVisitor(RfClass enclosingClass) {
            this.enclosingClass = enclosingClass;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (hidObject.isEventControl()) {
                if (this.scope instanceof RfActionBlock && ((RfActionBlock)this.scope).hasForkJoin() || Check_R_1235.this.pCheckOnlySequences && this.scope instanceof RfClass && !LintUtils.isSubClassOf((RfClass)this.scope, ((Check_R_1235)Check_R_1235.this).fOVMProject.fOvmSequence)) {
                    return true;
                }
                RfNamedElement parentScope = this.scope.getEnclosingScope();
                while (parentScope != null) {
                    if (parentScope instanceof RfActionBlock && ((RfActionBlock)parentScope).hasForkJoin() || Check_R_1235.this.pCheckOnlySequences && parentScope instanceof RfClass && !LintUtils.isSubClassOf((RfClass)parentScope, ((Check_R_1235)Check_R_1235.this).fOVMProject.fOvmSequence)) {
                        return true;
                    }
                    parentScope = parentScope.getEnclosingScope();
                }
                Set hidsFlatten = HidUtils.flattenToHids((IHidObject)hidObject, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));
                if (hidsFlatten.isEmpty()) {
                    return true;
                }
                for (IHid hid : hidsFlatten) {
                    if (!(hid instanceof RfHid)) {
                        return true;
                    }
                    RfHid rfHid = (RfHid)hid;
                    if (!(rfHid.getElement() instanceof RfNamedElement)) {
                        return true;
                    }
                    RfNamedElement namedElement = (RfNamedElement)rfHid.getElement();
                    IRfNamedElement enclosingScope = namedElement.getEnclosingScope(Check_R_1235.this.enclosingScopes);
                    if (enclosingScope instanceof RfClass || enclosingScope == null) {
                        return true;
                    }
                    if (Check_R_1235.this.pSkipSignalPatterns.isEmpty()) continue;
                    boolean isClockSignal = false;
                    for (Pattern pattern : Check_R_1235.this.pSkipSignalPatterns) {
                        if (!pattern.matcher(namedElement.getName()).matches()) continue;
                        isClockSignal = true;
                        break;
                    }
                    if (!isClockSignal) continue;
                    return true;
                }
                Check_R_1235.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Event control '" + HidUtils.toNiceString((IHidObject)hidObject) + "' with no timeout used in class '" + LintUtils.getNamedElementFullName(this.enclosingClass) + "'!");
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

