/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.r2lparser.R2LFilters;

@CheckVersion(value="23.1.22")
@CheckID(value="R.1236")
@CheckName(value="R.1236")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CLASS})
@CheckTitle(value="Add blank lines between class elements")
@CheckDescription(value="Including a blank line before and after elements makes the code more readable.\n\nExamples:\n function foo;\n endfunction\n function boo; // NOT ALLOWED\n endfunction\n\n function foo;\n endfunction\n\n function boo; // ALLOWED\n endfunction\n\nCheck supports pre-waiving.")
public class Check_R_1236
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String ERROR_MESSAGE = "Insert blank line {0} {1} ''{2}''!";
    private final Set<String> namedElementsStrings = new HashSet<String>(Arrays.asList("typedef", "function", "task", "covergroup", "constraint"));
    private final Set<String> startQualifiers = new HashSet<String>(Arrays.asList("extern", "virtual", "static", "local", "protected", "pure"));
    private Map<String, String> expectedEndMap;
    @CheckParameter(defaultValue="function, task, constraint", description="Comma separated list of element kinds to be checked. Possible values: function, task, constraint, covergroup, typedef.", name="elementKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pElementKinds;

    public Check_R_1236(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String elementKind : this.pElementKinds) {
            if (this.namedElementsStrings.contains(elementKind)) continue;
            this.signalParamError("Invalid value '" + elementKind + "' for parameter elementKinds!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.expectedEndMap = new HashMap<String, String>();
        this.expectedEndMap.put("constraint", "}");
        this.expectedEndMap.put("typedef", ";");
        this.expectedEndMap.put("extern", ";");
        this.expectedEndMap.put("pure", ";");
        this.expectedEndMap.put("function", "endfunction");
        this.expectedEndMap.put("constructor", "endfunction");
        this.expectedEndMap.put("task", "endtask");
        this.expectedEndMap.put("covergroup", "endgroup");
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            RfFileDef file = clazz.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            HashSet<IRfNamedElement> namedElements = new HashSet<IRfNamedElement>();
            this.populateElements(namedElements, clazz);
            for (IRfNamedElement element : namedElements) {
                LiteralToken nextToken;
                LiteralToken endToken;
                RfNamedElement namedElement;
                if (!(element instanceof RfNamedElement) || (namedElement = (RfNamedElement)element).getDeclaration() == null || namedElement.getDeclaration().getReparseInfo() != null) continue;
                ParserPath parserPath = namedElement.getDeclaration().getParserPath();
                LiteralToken startToken = this.getStartToken(parserPath, namedElement);
                if (startToken != null) {
                    LiteralToken prevToken = this.getWSParser().getPrevToken(startToken, parserPath);
                    if (prevToken == null) continue;
                    int start = startToken.getLineNumber();
                    if (start - prevToken.getLineNumber() < 2) {
                        this.addHit(parserPath, start, MessageFormat.format(ERROR_MESSAGE, "before", namedElement.getKindName(), LintUtils.getNamedElementFullName(namedElement)), null);
                    }
                }
                if ((endToken = this.getEndToken(parserPath, namedElement)) == null || (nextToken = this.getWSParser().getNextToken(endToken, parserPath)) == null) continue;
                int end = endToken.getLineNumber();
                if (nextToken.getLineNumber() - end >= 2) continue;
                this.addHit(parserPath, end, MessageFormat.format(ERROR_MESSAGE, "after", namedElement.getKindName(), LintUtils.getNamedElementFullName(namedElement)), null);
            }
        }
    }

    private void populateElements(Collection<IRfNamedElement> namedElements, RfNamedElement clazz) {
        if (this.pElementKinds.isEmpty()) {
            return;
        }
        IRfElementFilter composedFilter = R2LFilters.or(this.pElementKinds.contains("constraint") ? R2LFilters.isConstraint(true) : null, this.pElementKinds.contains("covergroup") ? R2LFilters.isCovergroup(true) : null, this.pElementKinds.contains("function") && this.pElementKinds.contains("task") ? R2LFilters.isFunction(true) : null, this.pElementKinds.contains("task") && !this.pElementKinds.contains("function") ? R2LFilters.functionIsTask(true) : null, this.pElementKinds.contains("function") && !this.pElementKinds.contains("task") ? R2LFilters.functionIsTask(false) : null, this.pElementKinds.contains("typedef") ? R2LFilters.isTypeAlias(true) : null);
        clazz.getElementsWithPrefix(namedElements, "", 2, 1, false, IRfNamedElement.AccessModifier.SHOW_PRIVATE, composedFilter);
    }

    /*
     * Unable to fully structure code
     */
    private LiteralToken getStartToken(ParserPath parserPath, RfNamedElement namedElement) {
        commentBlock = namedElement.getCommentBlock();
        if (commentBlock != null) {
            commentBlockLine = commentBlock.getAboveCommentStartLine();
            firstToken = this.getWSParser().getFirstTokenOnLine(parserPath, commentBlockLine);
            if (firstToken != null) {
                return firstToken;
            }
        }
        startOffset = namedElement.getDeclaration().getStartOffset();
        startToken = this.getWSParser().getTokenContainingOffset(startOffset, parserPath);
        if (startToken != null) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            startToken = this.getWSParser().getPrevToken(startToken, parserPath);
            if (startToken != null) continue;
            return null;
lbl14:
            // 2 sources

            ** while (!this.isStartToken((LiteralToken)startToken))
        }
lbl15:
        // 1 sources

        potentialStartToken = this.getWSParser().getPrevToken(startToken, parserPath);
        if (potentialStartToken == null) {
            return startToken;
        }
        i = 0;
        while (i < this.startQualifiers.size()) {
            if (this.startQualifiers.contains(potentialStartToken.toString())) {
                startToken = potentialStartToken;
            }
            if (!startToken.equals(potentialStartToken) && potentialStartToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                return startToken;
            }
            potentialStartToken = this.getWSParser().getPrevToken(potentialStartToken, parserPath);
            ++i;
        }
        return startToken;
    }

    private boolean isStartToken(LiteralToken literalToken) {
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        return this.namedElementsStrings.contains(text);
    }

    private LiteralToken getEndToken(ParserPath parserPath, RfNamedElement namedElement) {
        LiteralToken endToken;
        int endOffset = namedElement.getDeclaration().getEndOffset();
        if (namedElement.getDeclaration().hasEndLabel()) {
            endOffset = namedElement.getDeclaration().getEndLabelOffset();
        }
        if ((endToken = this.getWSParser().getTokenContainingOffset(endOffset, parserPath)) == null) {
            return null;
        }
        String neKindName = namedElement.getKindName().startsWith("typedef") ? "typedef" : (namedElement.isExtern() || namedElement.isPure() ? "extern" : namedElement.getKindName());
        String expectedEndString = this.expectedEndMap.get(neKindName);
        if (expectedEndString == null) {
            return endToken;
        }
        if (namedElement.getDeclaration().hasEndLabel()) {
            expectedEndString = namedElement.getName();
        }
        if ("typedef".equals(neKindName) || namedElement.isExtern()) {
            while (!endToken.toString().contains(";")) {
                endToken = this.getWSParser().getNextToken(endToken, parserPath);
                if (endToken != null) continue;
                return null;
            }
        }
        if (this.isEndLineHit(parserPath, endToken, expectedEndString, namedElement)) {
            return null;
        }
        return endToken;
    }

    boolean isEndLineHit(ParserPath parserPath, LiteralToken endToken, String expectedEndString, RfNamedElement namedElement) {
        if (endToken.toString().endsWith(";;")) {
            this.addHit(parserPath, endToken.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, "after", namedElement.getKindName(), LintUtils.getNamedElementFullName(namedElement)), null);
            return true;
        }
        if (!endToken.toString().endsWith(expectedEndString)) {
            this.addHit(parserPath, endToken.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, "after", namedElement.getKindName(), LintUtils.getNamedElementFullName(namedElement)), null);
            return true;
        }
        return false;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

