/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1238")
@CheckName(value="R.1238")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.AGENT, RuleLabel.CLASS_INSTANTIATION, RuleLabel.ENVIRONMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Group multiple instances of the same agent")
@CheckDescription(value="Multiple instances of the same agent must be in the same environment in order to form a component hierarchy.\nA nested hierarchy of verification environments may arise as verification environments are reused from the block level to the system level.\n\nExample:\n\nclass my_env extends uvm_env;\n\tmy_agent agent1; // allowed\n  my_agent agent2; // allowed\n  my_other_agent other_agent; // not allowed, more than one type of agent in an environment\nendclass\n\nclass my_env2 extends uvm_env;\n  my_second_agent second_agent2; // not allowed, same type of agent used in my_env3\nendclass\n\nclass my_env3 extends uvm_env;\n  my_second_agent second_agent3; // not allowed, same type of agent used in my_env2\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1238
extends OVMComplianceCheck {
    Map<RfDefElement, List<RfField>> agentsToInstancesMap;
    Map<RfClass, List<RfDefElement>> instancesToAgentsMap;
    Map<RfField, RfClass> instanceToEnvMap;
    Set<RfDefElement> checkedAgents;
    private static final String ERROR_MESSAGE_FORMAT = "Agent ''{0}'' is instantiated in more than one environment:\n{1}";
    private static final String ERROR_ENV_MESSAGE_FORMAT = "Environment ''{0}'' instantiates more than one type of agent: {1}";

    public Check_R_1238(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.agentsToInstancesMap = new LinkedHashMap<RfDefElement, List<RfField>>();
        this.instancesToAgentsMap = new LinkedHashMap<RfClass, List<RfDefElement>>();
        this.checkedAgents = new HashSet<RfDefElement>();
        this.instanceToEnvMap = new HashMap<RfField, RfClass>();
        Collection<RfClass> allEnvs = this.fOVMProject.fEnvs.values();
        for (RfClass rfClass : allEnvs) {
            if (this.checkPreWaivers(rfClass.getFile())) continue;
            this.notifyCheckAlive();
            this.checkedAgents.clear();
            List<RfField> fields = rfClass.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (fields == null || fields.isEmpty()) continue;
            for (RfField rfField : fields) {
                RfDefElement agentDef;
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(rfField);
                if (fieldType == null || !this.fOVMProject.isAgent(fieldType) || this.checkedAgents.contains(agentDef = fieldType.getDeclaration())) continue;
                List<RfField> agentInstances = this.agentsToInstancesMap.get(agentDef);
                if (agentInstances == null) {
                    agentInstances = new ArrayList<RfField>();
                    this.agentsToInstancesMap.put(agentDef, agentInstances);
                }
                agentInstances.add(rfField);
                this.checkedAgents.add(agentDef);
                this.instanceToEnvMap.put(rfField, rfClass);
            }
        }
        for (Map.Entry entry : this.agentsToInstancesMap.entrySet()) {
            for (RfField instance : (List)entry.getValue()) {
                RfClass instanceClass = this.instanceToEnvMap.get(instance);
                if (!this.instancesToAgentsMap.containsKey(instanceClass)) {
                    this.instancesToAgentsMap.put(instanceClass, new ArrayList());
                }
                this.instancesToAgentsMap.get(instanceClass).add((RfDefElement)entry.getKey());
            }
        }
        for (Map.Entry entry : this.agentsToInstancesMap.entrySet()) {
            RfDefElement agent = (RfDefElement)entry.getKey();
            List list = (List)entry.getValue();
            if (list.size() <= 1) continue;
            this.addHit(agent.getNamedElement(), this.getErrorMessage(agent, list), null);
        }
        for (Map.Entry entry : this.instancesToAgentsMap.entrySet()) {
            RfClass env = (RfClass)entry.getKey();
            List list = (List)entry.getValue();
            if (list.size() <= 1) continue;
            this.addHit(env.getNamedElement(), this.getErrorMessageEnv(env, list), null);
        }
    }

    private String getErrorMessage(RfDefElement agent, List<RfField> agentInstances) {
        StringBuilder envsMessage = new StringBuilder();
        for (RfField instance : agentInstances) {
            ParserPath parserPath;
            RfFileDef instanceFile = instance.getFile();
            if (instanceFile == null || (parserPath = instanceFile.getParserPath()) == null) continue;
            envsMessage.append("'").append(this.instanceToEnvMap.get(instance).getName()).append("'").append(this.link(" at line " + instance.getLine() + " of " + LintUtils.getFileShortName(parserPath.toString()), parserPath.toString(), instance.getLine())).append("\n");
        }
        String errorMessage = MessageFormat.format(ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(agent.getNamedElement()), envsMessage.toString());
        if (errorMessage.endsWith("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
        }
        return errorMessage;
    }

    private String getErrorMessageEnv(RfClass env, List<RfDefElement> agentTypes) {
        StringBuilder envsMessage = new StringBuilder();
        agentTypes.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (RfDefElement agent : agentTypes) {
            ParserPath parserPath = agent.getParserPath();
            if (parserPath == null) continue;
            envsMessage.append("'").append(agent.getNamedElement()).append("'").append(", ");
        }
        String errorMessage = MessageFormat.format(ERROR_ENV_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(env.getNamedElement()), envsMessage.toString());
        if (errorMessage.endsWith(", ")) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 2);
        }
        return errorMessage;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

