/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.22")
@CheckID(value="R.1239")
@CheckName(value="R.1239")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.MACRO, RuleLabel.SEQUENCER, RuleLabel.VERIFICATION})
@CheckTitle(value="Use the `uvm_declare_p_sequencer macro to declare the p_sequencer variable inside sequences")
@CheckDescription(value="First level sequences (ones that inherit directly from uvm_sequence) must call the `uvm_declare_p_sequencer macro.\nTo get the sequencer on which the sequence is running uvm_sequence_item::get_sequencer() can also be used, but it's return type is uvm_sequencer_base.\nThe macro `uvm_declare_p_sequencer allows you to define a specific sequencer type.\n\nExample:\nclass my_seq extends uvm_sequence;       // not allowed\nendclass\n\nclass my_seq extends uvm_sequence;       // allowed\n\t`uvm_declare_p_sequencer(SEQUENCER);\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1239
extends OVMComplianceCheck {
    private final String MACRO_NAME = "uvm_declare_p_sequencer";

    public Check_R_1239(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.fOvmSequence;
        if (baseClass == null) {
            return;
        }
        Set<RfClass> sequences = baseClass.getChildren();
        if (sequences == null || sequences.isEmpty()) {
            return;
        }
        for (RfClass sequence : sequences) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(sequence.getFile()) || sequence.equals(baseClass) || sequence.getParent() == null || !sequence.getParent().getFullName().equals(baseClass.getFullName()) || this.checkClass(sequence)) continue;
            this.addHit(sequence, "The `uvm_declare_p_sequencer macro is not called inside the sequence class '" + LintUtils.getNamedElementFullName(sequence) + "'!");
        }
    }

    protected boolean checkClass(RfClass clazz) {
        HidVisitor visitor = new HidVisitor("uvm_declare_p_sequencer");
        clazz.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        return visitor.hasMacro;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static class HidVisitor
    extends RfHidVisitor {
        private String macroName;
        private boolean hasMacro;

        public HidVisitor(String macroName) {
            this.macroName = macroName;
            this.hasMacro = false;
        }

        public boolean visit(RfHid hidObject) {
            IReparseInfo reparseInfo = hidObject.getReparseInfo();
            if (reparseInfo != null && this.macroName.equals(reparseInfo.getLastReparseMacroName())) {
                this.hasMacro = true;
                return false;
            }
            return true;
        }
    }
}

