/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractConfigClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1240")
@CheckName(value="R.1240")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.CONFIG_OBJECT, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="All user defined configuration class names should match a naming pattern")
@CheckDescription(value="This rule checks that all user defined configuration class names match <namePattern>.\n\nImplementation notes:\nA configuration class is a class that extends from xvm_object and has at least one field. \nThe configuration class cannot contain fields of type class with the exception of other configuration class handles.\n\nExamples when namePattern is '.*_config':\n\nclass example_cfg extends xvm_pkg::xvm_object;  // not allowed, name does not match\n   int a;\n   example_config b; // configuration class\nendclass\n\nclass example_config extends xvm_pkg::xvm_object;  //allowed\n   int a;\n   byte b;\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1240
extends AbstractConfigClassCheck {
    @CheckParameter(defaultValue=".*_config", description="All configuration classes must match this pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern namePattern;

    public Check_R_1240(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            Matcher m;
            if (this.checkPreWaivers(clazz.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            if (!this.checkConfigClass(clazz) || (m = this.namePattern.matcher(clazz.getName())).matches()) continue;
            this.addHit(clazz, "User defined configuration class '" + LintUtils.getNamedElementFullName(clazz) + "' should match '" + this.namePattern.pattern() + "' pattern!");
        }
    }
}

