/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractConfigClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1241")
@CheckName(value="R.1241")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.FIELD, RuleLabel.CONFIG_DB, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="When referencing config objects using the uvm_config_db the field name should match a naming pattern")
@CheckDescription(value="This rule will check that all uvm_pkg::uvm_config_db.set and uvm_pkg::uvm_config_db.get calls have field names that match <namePattern>.\n\nExamples when namePattern is '.*_config':\n\nuvm_pkg::uvm_config_db#(example_config)::set(this, \"\", \"cfg\", value);        // not allowed\nuvm_pkg::uvm_config_db#(example_config)::get(this, \"\", \"cfg_config\", value); //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1241
extends AbstractConfigClassCheck {
    @CheckParameter(defaultValue=".*_config", description="All field names should match this pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern namePattern;

    public Check_R_1241(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        RfHidVisitor callVisitor = new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                if (Check_R_1241.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                    return true;
                }
                IRfNamedElement element = rfHid.getElement();
                if (element == null || !(element instanceof RfFunction)) {
                    return true;
                }
                if (Check_R_1241.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1241.this.notifyCheckAlive();
                if (!"uvm_pkg::uvm_config_db.set".equals(((RfFunction)element).getFullName()) && !"uvm_pkg::uvm_config_db.get".equals(((RfFunction)element).getFullName())) {
                    return true;
                }
                HidAccess parentAccess = rfHid.getParentAccess();
                if (parentAccess == null) {
                    return true;
                }
                IRfNamedElement associatedType = parentAccess.getAssociatedType();
                if (associatedType == null || !(associatedType instanceof RfSpecializedClass)) {
                    return true;
                }
                Map<String, IELParamValue> parameterValues = ((RfSpecializedClass)associatedType).getLocalElabConstantValues();
                if (parameterValues == null || parameterValues.isEmpty()) {
                    return true;
                }
                boolean configClassCheck = false;
                for (IELParamValue paramValue : parameterValues.values()) {
                    IRfNamedElement namedElement;
                    if (paramValue == null || (namedElement = paramValue.getNamedElement()) == null || !(namedElement instanceof RfClass) || !Check_R_1241.this.checkConfigClass((RfClass)namedElement)) continue;
                    configClassCheck = true;
                    break;
                }
                if (!configClassCheck) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        Matcher m;
                        RfHidImplicit rfHidImplicit;
                        if (!"field_name".equals(((IRfFieldElement)entry.getKey()).getName()) || entry.getValue() == null || !(entry.getValue() instanceof RfHidImplicit) || (rfHidImplicit = (RfHidImplicit)entry.getValue()) == null || (m = Check_R_1241.this.namePattern.matcher(Check_R_1241.this.removeTicks(rfHidImplicit.getName()))).matches()) continue;
                        Check_R_1241.this.addHit(this.parserPath, rfHid, "Field name " + rfHidImplicit.getName() + " should match '" + Check_R_1241.this.namePattern.pattern() + "' when calling '" + LintUtils.getHidFullName((IHid)rfHid) + "'!");
                    }
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, callVisitor);
    }
}

