/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1242")
@CheckName(value="R.1242")
@CheckLabel(labels={RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Define a base virtual sequence")
@CheckDescription(value="A base virtual sequence that matches <namePattern> should be defined. All the other virtual sequences must extend the base virtual sequence.\nA virtual sequence is a sequence that extends uvm_sequence with the default parameter value (uvm_sequence_item).\nA base virtual sequence extends uvm_sequence directly.\n\nExample:\n\nclass uvm_base_vseq extends uvm_sequence#();\nendclass\n\nclass uvm_vseq2 extends uvm_sequence#(); // not allowed\nendclass\n\nclass uvm_vseq1 extends uvm_base_vseq; // allowed\nendclass\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1242
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_base_vseq", description="The base virtual sequence name pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePattern;
    Set<RfClass> allSequences = new HashSet<RfClass>();
    Set<RfClass> baseVirtualSequences = new HashSet<RfClass>();
    Set<RfClass> virtualSequences = new LinkedHashSet<RfClass>();
    String sequenceClassName;

    public Check_R_1242(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.baseVirtualSequences.clear();
        this.virtualSequences.clear();
        if (this.fOVMProject.fOvmSequence == null) {
            return;
        }
        this.sequenceClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence");
        this.allSequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        this.populateVirtualSequences();
        if (this.baseVirtualSequences.isEmpty()) {
            this.addHit(null, "No base virtual sequence defined!");
            return;
        }
        for (RfClass baseVirtualSequence : this.baseVirtualSequences) {
            if (this.pNamePattern.matcher(baseVirtualSequence.getName()).matches()) continue;
            this.addHit(baseVirtualSequence, "Base virtual sequence '" + LintUtils.getNamedElementFullName(baseVirtualSequence) + "' does not respect the naming pattern!");
        }
        for (RfClass virtualSequence : this.virtualSequences) {
            boolean isFailure = true;
            this.notifyCheckAlive();
            for (RfClass baseVirtualSequence : this.baseVirtualSequences) {
                if (!LintUtils.isSubClassOf(virtualSequence, baseVirtualSequence)) continue;
                isFailure = false;
                break;
            }
            if (!isFailure) continue;
            this.addHit(virtualSequence, "Virtual sequence '" + LintUtils.getNamedElementFullName(virtualSequence) + "' does not extend a base virtual sequence!");
        }
    }

    private void populateVirtualSequences() {
        for (RfClass sequence : this.allSequences) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(sequence.getFile())) continue;
            if (this.fOVMProject.fOvmSequenceItem == null) break;
            if (!LintUtils.isVirtualSequence(sequence, this.fOVMProject.fOvmSequence, this.fOVMProject.fOvmSequenceItem)) continue;
            RfClass sequenceParent = sequence.getParent();
            Set<RfClass> sequenceChildren = sequence.getChildren();
            if (sequenceParent != null && sequenceParent.getFullName().equals(this.sequenceClassName) && sequenceChildren != null && !sequenceChildren.isEmpty()) {
                this.baseVirtualSequences.add(sequence);
                continue;
            }
            this.virtualSequences.add(sequence);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

