/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.22")
@CheckID(value="R.1243")
@CheckName(value="R.1243")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.TEST, RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Use virtual sequences to coordinate the stimulus generation activities")
@CheckDescription(value="The run phase in tests must start at least one virtual sequence and have no non-virtual sequence start.\nThis check flags both starting a non virtual sequence using start() and not having at least one virtual sequence start.\nA virtual sequence is a sequence that extends xvm_sequence with the default parameter value (xvm_sequence_item).\n\nCheck supports pre-waiving.")
public class Check_R_1243
extends OVMComplianceCheck {
    private boolean hasVirtualSequenceStart;

    public Check_R_1243(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmTest == null || this.fOVMProject.fOvmSequence == null || this.fOVMProject.fOvmSequenceItem == null) {
            return;
        }
        Set<RfClass> allTests = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmTest);
        if (allTests.isEmpty()) {
            return;
        }
        HashSet<RfClass> hasVirtualSequenceStartClass = new HashSet<RfClass>();
        for (RfClass test : allTests) {
            boolean parentHasVirtualSequenceStart;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(test.getFile())) continue;
            String xvmRunPhaseMethodName = this.fOVMProject.getRunPhaseMethodName();
            RfClass parent = test.getParent();
            this.hasVirtualSequenceStart = parentHasVirtualSequenceStart = hasVirtualSequenceStartClass.contains(parent);
            RfFunction runPhaseFunction = test.getTaskWithPrefix(xvmRunPhaseMethodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (runPhaseFunction != null) {
                this.hasVirtualSequenceStart = false;
                if (runPhaseFunction.hasHidObjects()) {
                    runPhaseFunction.visitHidObject(null, new StartRunPhaseVisitor(test, parentHasVirtualSequenceStart));
                }
            }
            if (this.hasVirtualSequenceStart) {
                hasVirtualSequenceStartClass.add(test);
                continue;
            }
            if (parent.getGenericClass().equals(this.fOVMProject.fOvmTest)) continue;
            this.addHit(test, "Missing virtual sequence start in '" + LintUtils.getNamedElementFullName(test) + "' class!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class StartRunPhaseVisitor
    extends RfHidVisitor {
        private RfClass testClass;
        private boolean hasParentWithVirtualSequenceStart;
        private IRfNamedElement fScope;

        public StartRunPhaseVisitor(RfClass testClass, boolean hasParentWithVirtualSequenceStart) {
            this.testClass = testClass;
            this.hasParentWithVirtualSequenceStart = hasParentWithVirtualSequenceStart;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.fScope = ((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHid rfHid) {
            RfClass sequence;
            HidAccess acc = rfHid.getFirstAccess();
            if (acc == null || !(acc instanceof RfHidAccessArgs)) {
                return true;
            }
            Hid calledFunction = ((RfHidAccessArgs)acc).getParentHid();
            if (calledFunction == null) {
                return true;
            }
            IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)calledFunction);
            if (resolvedElement == null || !(resolvedElement instanceof RfFunction)) {
                return true;
            }
            if (!"start".equals(resolvedElement.getName()) && !"run_phase".equals(resolvedElement.getName())) {
                return true;
            }
            Hid parentHid = rfHid.getParentHid();
            if (parentHid == null) {
                return true;
            }
            IRfNamedElement parentElement = HidUtils.getResolvedElement((IHidObject)parentHid);
            if (parentElement == null || !(parentElement instanceof RfField)) {
                return true;
            }
            if ("super".equals(parentElement.getName())) {
                Check_R_1243.this.hasVirtualSequenceStart = Check_R_1243.this.hasVirtualSequenceStart || this.hasParentWithVirtualSequenceStart;
                return true;
            }
            IRfNamedElement scope = this.fScope;
            RfClass enclosingScope = (RfClass)scope.getEnclosingScope(RfClass.class);
            if (enclosingScope != null) {
                scope = enclosingScope.getDefaultSpecialization(null);
            }
            if ((sequence = LintUtils.getFieldFinalClassTypeOrNull((RfField)parentElement, RfTypesResolver.create((IRfScopeElement)scope, Check_R_1243.this.fOVMProject.getRfProject(), 6))) == null || !LintUtils.isSubClassOf(sequence, ((Check_R_1243)Check_R_1243.this).fOVMProject.fOvmSequence)) {
                return true;
            }
            if (LintUtils.isVirtualSequence(sequence, ((Check_R_1243)Check_R_1243.this).fOVMProject.fOvmSequence, ((Check_R_1243)Check_R_1243.this).fOVMProject.fOvmSequenceItem)) {
                Check_R_1243.this.hasVirtualSequenceStart = true;
                return true;
            }
            Check_R_1243.this.addHit(this.parserPath, rfHid, "Non-virtual sequence start: '" + LintUtils.getNamedElementFullName((RfField)parentElement) + "' of type '" + LintUtils.getNamedElementFullName(sequence) + "' started in '" + LintUtils.getNamedElementFullName(this.testClass) + "' class !");
            return true;
        }
    }
}

