/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.22")
@CheckID(value="R.1244")
@CheckName(value="R.1244")
@CheckLabel(labels={RuleLabel.DELAY, RuleLabel.DRIVER, RuleLabel.MONITOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use explicit delays outside of drivers and monitors")
@CheckDescription(value="Usage of delay statements, edge and wait events are forbidden outside drivers and monitors\n\nXVM components or sequences that provide transactions to the driver should provide transaction-level ports and exports that do not block the execution of the driver so that it is always able to react immediately to signals in the DUT\n\nExample:\n\nclass A extends xvm_driver;\n\tfunction foo(clk);\n\t\t#10;\t\t\t\t\t\t\t// allowed\n\tendfunction\nendclass\n\nclass B extends xvm_object;\n\tfunction foo(clk);\n\t\twhile (1) begin\n\t\t\t@(clk);\t\t\t\t\t\t// not allowed\n\t\tend\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1244
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, virtual sequences will be skipped from checking.", name="skipVirtualSequences", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipVirtualSequences;
    @CheckParameter(defaultValue="false", description="When true, covergroups will be skipped from checking.", name="skipCovergroups", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCovergroups;

    public Check_R_1244(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass driverClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_driver"), true);
        RfClass monitorClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_monitor"), true);
        HashSet<RfClass> baseClasses = new HashSet<RfClass>(Arrays.asList(driverClass, monitorClass));
        if (driverClass == null || monitorClass == null) {
            return;
        }
        LocalHidVisitor visitor = new LocalHidVisitor();
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(clazz.getFile()) || this.pSkipVirtualSequences && LintUtils.isVirtualSequence(clazz, this.fOVMProject.fOvmSequence, this.fOVMProject.fOvmSequenceItem) || LintUtils.isSubClassOfAny(clazz, baseClasses)) continue;
            clazz.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class LocalHidVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (Check_R_1244.this.pSkipCovergroups && this.scope.getEnclosingScope(RfCovergroup.class) != null) {
                return true;
            }
            if (hidObject.isWaitEventControl()) {
                Check_R_1244.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Wait statement '" + HidUtils.toNiceString((IHidObject)hidObject) + "' used outside a driver or a monitor!");
            } else if (hidObject.isEventControl()) {
                Check_R_1244.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Event control '" + HidUtils.toNiceString((IHidObject)hidObject) + "' used outside a driver or a monitor!");
            } else if (hidObject.isVlogDelayControlStatement()) {
                Check_R_1244.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Explicit delay '" + HidUtils.toNiceString((IHidObject)hidObject) + "' used outside a driver or a monitor!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

