/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1245")
@CheckName(value="R.1245")
@CheckLabel(labels={RuleLabel.OBJECTION, RuleLabel.SCOREBOARD, RuleLabel.VERIFICATION})
@CheckTitle(value="Raise and drop objections in the scoreboard")
@CheckDescription(value="Raise/Drop objection must be called in the scoreboard or, must override 'check_phase' method\nIn order to shut down the simulation, it is important to know that all transactions are consumed and there is no transaction in flight to the DUT.\n\nExample:\n\nclass my_cls1 extends uvm_scoreboard;\t\t\t// allowed\n\ttask run_phase(uvm_phase phase);\n\t\tuvm_report_object obj;\n\t\tphase.raise_objection(obj);\n\t\tphase.drop_objection(obj);\n\tendtask\nendclass\n\nclass my_cls2 extends uvm_scoreboard;\t\t\t// allowed\n\tvirtual function check_phase();\n\t\t$display(\"end\");\n\tendtask\nendclass\n\nclass my_cls4 extends uvm_scoreboard;\t\t\t// not allowed\n\ttask run_phase(uvm_phase phase);\n\t\t$display(\"run phase\");\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1245
extends OVMComplianceCheck {
    RfClass xvmScoreboard;
    RfClass xvmObjection;

    public Check_R_1245(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmScoreboard == null) {
            return;
        }
        Set<RfClass> scoreboards = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmScoreboard);
        for (RfClass scoreboard : scoreboards) {
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(scoreboard.getDeclaration().getParserPath(), this) || !scoreboard.getFunctionsWithPrefix("check_phase", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).isEmpty()) continue;
            ObjectionsVisitor visitor = new ObjectionsVisitor();
            scoreboard.visitHidObject(this.fOVMProject.getRfProject(), visitor);
            if (visitor.getIsPresentFlag()) continue;
            this.addHit(scoreboard, "'" + scoreboard.getName() + "' scoreboard class does not raise/drop objections or override the '" + "check_phase" + "' method!");
        }
    }

    private static class ObjectionsVisitor
    extends RfHidVisitor {
        private boolean isPresentFlag = false;

        public boolean getIsPresentFlag() {
            return this.isPresentFlag;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (function.getName().equals("raise_objection") || function.getName().equals("drop_objection")) {
                this.isPresentFlag = true;
                return false;
            }
            return true;
        }
    }
}

