/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1246")
@CheckName(value="R.1246")
@CheckLabel(labels={RuleLabel.OBJECTION, RuleLabel.LOOP, RuleLabel.PERFORMANCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not raise or drop objection in loops")
@CheckDescription(value="Simulation execution speed is dominated by the instructions executed by the inner loops.\nRemoving objections from loops altogether will improve the simulation speed.\n\nExample:\n\nclass my_test extends uvm_test;\n\ttask run_phase(uvm_phase phase);\n\t\tuvm_report_object obj;\n\t\tphase.raise_objection(obj); \t\t\t// allowed\n\t\tphase.drop_objection(obj);\n\tendtask\nendclass\n\nclass my_test extends uvm_test;\n\ttask run_phase(uvm_phase phase);\n\t\tuvm_report_object obj;\n\t\twhile (1) begin\n\t\t\tphase.raise_objection(obj);\t\t\t// not allowed\n\t\t\tphase.drop_objection(obj);\n\t\tend\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1246
extends OVMComplianceCheck {
    public Check_R_1246(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> allActionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : allActionBlocks) {
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(actionBlock.getDeclaration().getParserPath(), this) || !actionBlock.isLoop()) continue;
            actionBlock.visitHidObject(this.fOVMProject.getRfProject(), new RaiseObjectionsVisitor());
        }
    }

    private class RaiseObjectionsVisitor
    extends RfHidVisitor {
        private RaiseObjectionsVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (function.getName().equals("raise_objection") || function.getName().equals("drop_objection")) {
                Check_R_1246.this.addHit(this.parserPath, hidObject.getOccurrence(), "'" + function.getName() + "' objection was raised inside a loop!");
                return false;
            }
            return true;
        }

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }
    }
}

